/**************************************************************************************
 * @file         : ListQueueHandler.cpp
 * @author       : RBEI/ECH2-INF4CV_MediaTeam
 * @addtogroup   : AppHmi_media
 * @brief        :
 * @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 * 		  			Initial Revision.
 **************************************************************************************/

#include "hall_std_if.h"
#include "Core/ListHandling/ListQueueHandler/ListQueueHandler.h"
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "Core/ListHandling/ListInfoDatabaseHandler/ListInfoDatabaseHandler.h"
#include "AppHmi_MasterBase/AudioInterface/AudioDefines.h"
#include <vector>

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_MEDIA_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_MEDIA
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_MEDIA_"
#define ETG_I_FILE_PREFIX                 App::Core::ListQueueHandler::
#include "trcGenProj/Header/ListQueueHandler.cpp.trc.h"
#endif

#endif

#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
#include "utest/stubs/Apphmi_Media_Types_Common.h"
#include "Core/utest/stubs/Core/ListInfoDatabaseHandler.h"
#endif
namespace App {
namespace Core {


ListQueueHandler::ListQueueHandler(ListInfoDatabaseHandler* _listInfoDBHandler)
{
   ETG_TRACE_USR1(("ListQueueHandler constructor \n"));
   initializeQueuedInfo();
   isRequestQueued = false;
   _listDBHandler = _listInfoDBHandler;
}


void ListQueueHandler::initializeQueuedInfo()
{
   queuedListInfo = (struct queueListInfo)
   {
      EnumConst::entListType_Invalid, 0, 0
   };
}


ListQueueHandler::~ListQueueHandler()
{
   ETG_TRACE_USR1(("ListQueueHandler Destructor \n"));
   resetMembers();
}


void ListQueueHandler::resetMembers()
{
   ETG_TRACE_USR1(("ListQueueHandler resetMembers \n"));
   clearListQueue();
}


bool ListQueueHandler::isListRequestQueued()
{
   ETG_TRACE_USR4(("ListQueueHandler isListRequestQueued isRequestQueued %d", isRequestQueued));
   return isRequestQueued;
}


void ListQueueHandler::queueListRequest(struct queueListInfo& queueListInfo)
{
   ETG_TRACE_USR1(("ListQueueHandler queueListRequest \n"));
   queuedListInfo = queueListInfo;
   isRequestQueued = true;
}


struct queueListInfo& ListQueueHandler::getQueuedListInfo()
{
   ETG_TRACE_USR1(("ListQueueHandler getQueuedListInfo \n"));
   return queuedListInfo;
}


void ListQueueHandler::clearListQueue()
{
   ETG_TRACE_USR1(("ListQueueHandler clearListQueue \n"));
   isRequestQueued = false;
   initializeQueuedInfo();
}


bool ListQueueHandler::isRequestValid(EnumConst::entListType listType)
{
   bool isRequestValid = true;

   enListState queuedListState = _listDBHandler->getListStateOnListDataRequest(queuedListInfo.listType);

   if (queuedListState == EN_LIST_STATE_PROCESSING)
   {
      isRequestValid = false;
   }
   ETG_TRACE_USR4(("ListQueueHandler isRequestValid isRequestValid  %d   queuedListState   %d ", isRequestValid, ETG_CENUM(enListState, queuedListState)));
   return isRequestValid;
}


}// namespace Core
}// namespace App
