/**************************************************************************************
* @file         : VerticalListGuiResponseHandler.h
* @author       : RBEI/ECH2-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
* 		  			Initial Revision.
**************************************************************************************/

#ifndef _VerticalListGuiResponseHandler_H_
#define _VerticalListGuiResponseHandler_H_

#include "AppBase/ServiceAvailableIF.h"
#include "AppHmi_MediaStateMachine.h"
#include "AppHmi_MediaDatabinding.h"
#include "AvdeccPluginConstant.h"
#include "Core/ListHandling/ListConfiguration/ListConfiguration.h"
#include "Core/ListHandling/ListContainer/ListContainer.h"
#include "Core/MediaDefines.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "List/Data/ListDataProviderDistributor.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "DataModel/ListRegistry.h"
#include <bits/stdc++.h>

namespace App {
namespace Core {

class ListContainer;
class ListConfiguration;

class VerticalListGuiResponseHandler : public ListImplementation
{
   public:
      VerticalListGuiResponseHandler(ListContainer* _container, ListConfiguration* _listConfiguration);
      virtual ~VerticalListGuiResponseHandler();
      void initVerticalListSize();

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_MEDIA_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()

      uint32 updateDataIconInList(EnumConst::entListType listType);
      void updateListContent(EnumConst::entListType listType, uint16 verticalStartIndex, uint32 totalListSize);
      void oneFieldListCreation(EnumConst::entListType listType);
      void oneFieldListCreationForVideoLanguage(EnumConst::entListType listType);
      void updateSizeAndVisibilityDuringListBuild(EnumConst::entListType listType);
      void updateVerticalListSize(float backButtonSize, float allAlbumAndTitleButtonSize, float verticalListSize, float verticalListWidth, float scrollBarWidth);
      void updateEmptyListData(EnumConst::entListType listType);
      void updateBackAndAllButtonVisibility(bool backBtnVisibility, bool allBtnVisibility);
      void updateListVisibility(bool listVisibility);
      void updateTitleAndAlbumIconVisibility(bool titleIconVisibility, bool albumIconVisibility);
      void updateButtonText(Candera::String text);
      void resetMembers();
      void updateListInfoText(bool listState);
      void twoFieldListCreation(EnumConst::entListType listType);

   private:

      void vCreateMapListTypeInfo();

      ListContainer* _listDataContainer;
      ListConfiguration* _listConfig;
      VerticalListSize _verticalListsize;
      uint16 m_startIndex;
      uint32 m_totalListsize;

      DataBindingItem<BrowserScreenListSizeDataBindingSource> m_ExternalBrowseScreenListSize;
      DataBindingItem<BrowseListInfoTextDataBindingSource> m_BrowseListInfoText;
      std::map <EnumConst::entListType, const char*> _listTypeInfo;
};


} // namespace Core
} // namespace App


#endif  /* _VerticalListGuiResponseHandler_H_ */
