
#ifndef _HorizontalListGuiResponseHandler_H_
#define _HorizontalListGuiResponseHandler_H_

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "AppBase/ServiceAvailableIF.h"
#include "List/Data/ListDataProviderDistributor.h"
#include "AppHmi_MediaStateMachine.h"
#include "AppHmi_MediaDatabinding.h"
#include "Core/MediaDefines.h"
#include "Core/ExternalMediaDefines.h"
#include "AvdeccPluginConstant.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "Common/DataModel/ListRegistry.h"
#include <bits/stdc++.h>
#include "Core/Utils/PlayableContentMap.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
#include "utest/stubs/Apphmi_Media_Types_Common.h"
#include "utest/stubs/AudioDefines.h"
#include "utest/stubs/ProjectBaseTypes.h"

#endif

namespace App {
namespace Core {

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
class HorizontalListGuiResponseHandler : public ListImplementation
#else
class HorizontalListGuiResponseHandler
#endif
{
   public:
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      HorizontalListGuiResponseHandler(PlayableContentMap* _playableContentMapInstance, EnumConst::entSourceType sourceType);
      virtual ~HorizontalListGuiResponseHandler();
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_MEDIA_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()
#endif

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      void updateListContent();
      tSharedPtrDataProvider buildHorizontalList();
      void vCreateMapListTypetoListTabInfo();
      void resetMembers();
#endif

      int onScrollToIndex();
      void updateListType(EnumConst::entListType listType);
      void updateListStartIndex(int startIndex);
      bool isHorizontalListTabEnabled(int index);

   private :
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      DataBindingItem<TabVideoSourceDataBindingSource> _setTabVideoSource;
      DataBindingItem<TabNextPrevIndexDataBindingSource> _pageNextPrevIndex;
      std::map <uint8, HorizontalListTabInfo> m_ListTypetoTabInfo;
      PlayableContentMap* _playableContentMap;
      EnumConst::entSourceType _currentSourceType;
#endif
      int  m_u8startindex;
      EnumConst::entListType m_currentListType;

      //uint16 m_downloadStatus;
};


} // namespace Core
} // namespace App


#endif  /* _HorizontalListGuiResponseHandler_H_ */
