/**************************************************************************************
* @file         : ListGuiRequestHandler..h
* @author       : RBEI/ECH2-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
* 		  			Initial Revision.
**************************************************************************************/

#ifndef _ListGuiRequestHandler_H_
#define _ListGuiRequestHandler_H_

#include "AppBase/ServiceAvailableIF.h"
#include "List/Data/ListDataProviderDistributor.h"
#include "AppHmi_MediaStateMachine.h"
#include "AppHmi_MediaDatabinding.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "AvdeccPluginConstant.h"
#include "Core/MediaDefines.h"
#include <bits/stdc++.h>

using namespace Courier;


namespace App {
namespace Core {

class VerticalListManager;
class HorizontalListManager;

class ListGuiRequestHandler
{
   public:

      ListGuiRequestHandler(HorizontalListManager* _horizontalListManagerObj, VerticalListManager* _verticalListManagerObj);
      virtual ~ListGuiRequestHandler();

      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      void resetMembers();

      bool onCourierMessage(const ListChangedUpdMsg& oMsg);
      bool onCourierMessage(const ExternalMediaListItemPressUpdMsg& oMsg);
      bool onCourierMessage(const ExternalMediaTabBtnPressUpdMsg& oMsg);
      bool onCourierMessage(const ExternalMediaTabListPageUpReqMsg& oMsg);
      bool onCourierMessage(const ExternalMediaTabListPageDownReqMsg& oMsg);
      bool onCourierMessage(const ExternalMediaBackButtonPressUpdMsg& oMsg);
      bool onCourierMessage(const ExternalMediaAllButtonPressUpdMsg& oMsg);
      bool onCourierMessage(const ExternalBrowseScreenExitUpdMsg& oMsg);

   private:
      HorizontalListManager* _horizontalListManager;
      VerticalListManager* _verticalListManager;
      uint16 m_windowSize;
};


} // namespace Core
} // namespace App


#endif  /* _ListGuiRequestHandler_H_ */
