/**************************************************************************************
* @file         : ListContainer..h
* @author       : RBEI/ECH2-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
* 		  			Initial Revision.
**************************************************************************************/

#ifndef _ListContainer_H_
#define _ListContainer_H_

#include "Core/ExternalMediaDefines.h"
#include <vector>
#include <string>
#include "bosch/cm/di/HmiEmpListInterfaceProxy.h"

using namespace ::bosch::cm::di::HmiEmpListInterface;
using namespace std;

namespace App {
namespace Core {

class ListContainer
{
   public:
      ListContainer();
      virtual ~ListContainer();

      void setFirstTextOfList(std::vector<std::string> _firstMetadata);
      void setSecondTextOfList(std::vector<std::string> _secondMetadata);
      void setAbsoluteIndex(std::vector<uint16> _absoluteIndex);
      void setIsLanguageSelected(std::vector<bool> status);
      void setFileType(std::vector<bosch::cm::di::HmiEmpListInterface::entFileType> fileType);
      void updateIsAllLanguageSelected(bool status);
      std::vector<std::string> getFirstTextOfList();
      std::vector<std::string> getSecondTextOfList();
      std::vector<uint16> getAbsoluteIndex();
      std::vector<uint16> getSelectedLanguageId();
      void updateSelectedLanguageId();
      std::vector<bool> getIsLanguageSelected();
      uint16 getAbsoluteIndex(int selectedItem);
      bool isAllLanguageSelected();
      void resetMembers();
      int getFileType(int selectedRow);
      std::string getFolderName(int selectedItem);
      void updateFolderpath(std::string strPath);
      std::string getFolderPath();
      bool checkFileType(int index);

   private:
      std::vector<std::string> m_firstMetadata;
      std::vector<std::string> m_secondMetadata;
      std::vector<uint16> m_absoluteIndex;
      std::vector<uint16> _selectedLanguageId;
      std::vector<bool> _isLanguageSelected;
      std::vector<bosch::cm::di::HmiEmpListInterface::entFileType> _fileType;
      bool _isAllLanguageSelected;
      std::string _currentFolderPath;
};


} // namespace Core
} // namespace App


#endif  /* _ListContainer_H_ */
