/**************************************************************************************
* @file         : ListConfiguration..h
* @author       : RBEI/ECH2-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
* 		  			Initial Revision.
**************************************************************************************/

#ifndef _ListConfiguration_H_
#define _ListConfiguration_H_

#include "AppBase/ServiceAvailableIF.h"
#include "AppHmi_MediaStateMachine.h"
#include "AppHmi_MediaDatabinding.h"
#include "AvdeccPluginConstant.h"
#include "Core/ExternalMediaDefines.h"
#include <bits/stdc++.h>

namespace App {
namespace Core {

class ListConfiguration
{
   public:
      ListConfiguration();
      virtual ~ListConfiguration();
      void initilizeListConfiguration();

      bool getAllButtonAvilability(EnumConst::entListType listType);
      bool getPreviousButtonAvilability(EnumConst::entListType listType);
      int getTabGroup(EnumConst::entListType listType);
      bool isListTypeAvailable(EnumConst::entListType listType);
      EnumConst::entListType getPreviousListType(EnumConst::entListType listType);
      EnumConst::entListType getNextListType(EnumConst::entListType listType);
      int getNumberOfTextInList(EnumConst::entListType listType);
      uint32 getIconTypeForList(EnumConst::entListType listType);
      enListSliceRequestType getListSliceReqType(EnumConst::entListType listType);
      void resetMembers();
      EnumConst::entListType getAllListType(EnumConst::entListType listType);
      int requestedSourceId(EnumConst::entListType listType, EnumConst::entSourceType sourceType, int fileType);

   private:
      std::map <EnumConst::entListType, stListConfiguration> m_listTypeToListConfig;
};


} // namespace Core
} // namespace App


#endif  /* _ListConfiguration_H_ */
