/**************************************************************************************
 * @file         : ListConfiguration.cpp
 * @author       : RBEI/ECH2-INF4CV_MediaTeam
 * @addtogroup   : AppHmi_media
 * @brief        :
 * @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 * 		  			Initial Revision.
 **************************************************************************************/

#include "hall_std_if.h"
#include "Core/ListHandling/ListConfiguration/ListConfiguration.h"
#include "AppHmi_MasterBase/AudioInterface/AudioDefines.h"
#include <map>
#include <vector>


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_MEDIA_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_MEDIA
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_MEDIA_"
#define ETG_I_FILE_PREFIX                 App::Core::ListConfiguration::
#include "trcGenProj/Header/ListConfiguration.cpp.trc.h"
#endif

namespace App {
namespace Core {

ListConfiguration::ListConfiguration()
{
   ETG_TRACE_USR1(("ListConfiguration constructor \n"));
   initilizeListConfiguration();
}


ListConfiguration::~ListConfiguration()
{
   ETG_TRACE_USR1(("ListConfiguration Destructor \n"));
   resetMembers();
}


void ListConfiguration::resetMembers()
{
   ETG_TRACE_USR1(("ListConfiguration resetMembers \n"));
   m_listTypeToListConfig.clear();
}


void ListConfiguration::initilizeListConfiguration()
{
   ETG_TRACE_USR1(("ListConfiguration initilizeListConfiguration \n"));
   //isAllButtonAvailable,         nextListType,          numTextInListItem, isPrevButtonAvailable,      prevListType,           tabGroup,   icon,       allButtonListType
   m_listTypeToListConfig[EnumConst::entListType_Song] = stListConfiguration(false,               EnumConst::entListType_Invalid,       2,             false,            EnumConst::entListType_Invalid,        0,          0,     EnumConst::entListType_Invalid,		EN_AUDIO_FILE_CONTENT, EN_WINDOW_SLICE_REQ_TYPE);
   m_listTypeToListConfig[EnumConst::entListType_Album] = stListConfiguration(false,			  EnumConst::entListType_Album_Song,	1,             false,            EnumConst::entListType_Invalid,        0,          2,     EnumConst::entListType_Invalid,		EN_AUDIO_FILE_CONTENT, EN_WINDOW_SLICE_REQ_TYPE);
   m_listTypeToListConfig[EnumConst::entListType_Album_Song] = stListConfiguration(false,         EnumConst::entListType_Invalid,       2,             true,             EnumConst::entListType_Album,          0,			0,     EnumConst::entListType_Invalid,		EN_AUDIO_FILE_CONTENT, EN_WINDOW_SLICE_REQ_TYPE);
   m_listTypeToListConfig[EnumConst::entListType_Artist] = stListConfiguration(false,			  EnumConst::entListType_Artist_Album,	1,			   false,			 EnumConst::entListType_Invalid,		0,			1,	   EnumConst::entListType_Invalid,		EN_AUDIO_FILE_CONTENT, EN_WINDOW_SLICE_REQ_TYPE);
   m_listTypeToListConfig[EnumConst::entListType_Artist_Album] = stListConfiguration(true,        EnumConst::entListType_Artist_Album_Song, 2,         true,             EnumConst::entListType_Artist,         0,         2,      EnumConst::entListType_Artist_Song,	EN_AUDIO_FILE_CONTENT, EN_WINDOW_SLICE_REQ_TYPE);
   m_listTypeToListConfig[EnumConst::entListType_Artist_Album_Song] = stListConfiguration(false,  EnumConst::entListType_Invalid,       2,             true,             EnumConst::entListType_Artist_Album, 	0, 		   0, 	   EnumConst::entListType_Invalid,		EN_AUDIO_FILE_CONTENT, EN_WINDOW_SLICE_REQ_TYPE);
   m_listTypeToListConfig[EnumConst::entListType_Artist_Song] = stListConfiguration(false,        EnumConst::entListType_Invalid,       2,             true, 			 EnumConst::entListType_Artist_Album, 	0, 		   0, 	   EnumConst::entListType_Invalid,		EN_AUDIO_FILE_CONTENT, EN_WINDOW_SLICE_REQ_TYPE);
   m_listTypeToListConfig[EnumConst::entListType_Genre] = stListConfiguration(false,              EnumConst::entListType_Genre_Album,   1,             false, 			 EnumConst::entListType_Invalid, 		3,		   3,	   EnumConst::entListType_Invalid,		EN_AUDIO_FILE_CONTENT, EN_WINDOW_SLICE_REQ_TYPE);
   m_listTypeToListConfig[EnumConst::entListType_Genre_Album] = stListConfiguration(true,         EnumConst::entListType_Genre_Album_Song, 2,          true, 			 EnumConst::entListType_Genre, 			3,		   2,	   EnumConst::entListType_Genre_Song,	EN_AUDIO_FILE_CONTENT, EN_WINDOW_SLICE_REQ_TYPE);
   m_listTypeToListConfig[EnumConst::entListType_Genre_Album_Song] = stListConfiguration(false,   EnumConst::entListType_Genre_Song,    2,             true,			 EnumConst::entListType_Genre_Album,    3, 		   0,      EnumConst::entListType_Invalid,		EN_AUDIO_FILE_CONTENT, EN_WINDOW_SLICE_REQ_TYPE);
   m_listTypeToListConfig[EnumConst::entListType_Genre_Song] = stListConfiguration(false,         EnumConst::entListType_Invalid,       2,             true,			 EnumConst::entListType_Genre_Album, 	3, 		   0,      EnumConst::entListType_Invalid,		EN_AUDIO_FILE_CONTENT, EN_WINDOW_SLICE_REQ_TYPE);
   m_listTypeToListConfig[EnumConst::entListType_Playlist] = stListConfiguration(false,           EnumConst::entListType_Playlist_song, 1,             false,			 EnumConst::entListType_Invalid, 		3,		   4,      EnumConst::entListType_Invalid,		EN_AUDIO_FILE_CONTENT, EN_WINDOW_SLICE_REQ_TYPE);
   m_listTypeToListConfig[EnumConst::entListType_Playlist_song] = stListConfiguration(false,      EnumConst::entListType_Invalid,       2,             true,			 EnumConst::entListType_Playlist, 		3, 		   0,      EnumConst::entListType_Invalid,		EN_AUDIO_FILE_CONTENT, EN_WINDOW_SLICE_REQ_TYPE);
   m_listTypeToListConfig[EnumConst::entListType_Folder] = stListConfiguration(false,             EnumConst::entListType_Folder_file,   1,             false,			 EnumConst::entListType_Invalid, 		3,		   255,    EnumConst::entListType_Invalid,		EN_AUDIO_FILE_CONTENT, EN_WINDOW_SLICE_REQ_TYPE);
   m_listTypeToListConfig[EnumConst::entListType_Folder_file] = stListConfiguration(false,        EnumConst::entListType_Invalid,       2,             true,			 EnumConst::entListType_Folder, 		3, 		   255,	   EnumConst::entListType_Invalid,		EN_AUDIO_FILE_CONTENT, EN_WINDOW_SLICE_REQ_TYPE);
   m_listTypeToListConfig[EnumConst::entListType_Video] = stListConfiguration(false,			  EnumConst::entListType_Invalid,       2,			   false,			 EnumConst::entListType_Invalid,		6,		   7,	   EnumConst::entListType_Invalid,		EN_VIDEO_FILE_CONTENT, EN_WINDOW_SLICE_REQ_TYPE);
   m_listTypeToListConfig[EnumConst::entListType_Video_Languages] = stListConfiguration(false,            EnumConst::entListType_Invalid,       1,             false,			 EnumConst::entListType_Invalid, 		6,		   0,      EnumConst::entListType_Invalid,		EN_LANGUAGE_CONTENT, EN_FULL_LIST_SLICE_REQ_TYPE);
   m_listTypeToListConfig[EnumConst::entListType_Video_episode] = stListConfiguration(false,      EnumConst::entListType_Invalid,       2,             true,			 EnumConst::entListType_Video, 			6,		   7,      EnumConst::entListType_Invalid,		EN_VIDEO_FILE_CONTENT, EN_WINDOW_SLICE_REQ_TYPE);
   m_listTypeToListConfig[EnumConst::entListType_Invalid] = stListConfiguration(false,            EnumConst::entListType_Invalid,       0,             false,			 EnumConst::entListType_Invalid, 		0,		   0,      EnumConst::entListType_Invalid,		SRC_INVALID, EN_WINDOW_SLICE_REQ_TYPE);
}


bool ListConfiguration::isListTypeAvailable(EnumConst::entListType listType)
{
   std::map<EnumConst::entListType, stListConfiguration>::iterator mapIter = m_listTypeToListConfig.find(listType);
   bool bStatus = true;

   if (mapIter == m_listTypeToListConfig.end())
   {
      bStatus = false;
   }
   else
   {
      ETG_TRACE_USR1(("ListConfiguration isListTypeAvailable: listType available"));
   }
   ETG_TRACE_USR4(("ListConfiguration::isListInfoAvailable bStatus:%d", bStatus));
   return bStatus;
}


int ListConfiguration::getNumberOfTextInList(EnumConst::entListType listType)
{
   int iNumberOfTextLine = 0;
   if (isListTypeAvailable(listType))
   {
      iNumberOfTextLine = m_listTypeToListConfig[listType].numTextInListItem;
   }
   ETG_TRACE_USR4(("ListConfiguration getNumberOfTextInList iNumberOfTextLine  %d   listType   %d", iNumberOfTextLine, ETG_CENUM(entListType, listType)));
   return iNumberOfTextLine;
}


uint32 ListConfiguration::getIconTypeForList(EnumConst::entListType listType)
{
   uint32 idataIcon = 0;
   if (isListTypeAvailable(listType))
   {
      idataIcon = m_listTypeToListConfig[listType].icon;
   }

   ETG_TRACE_USR4(("ListConfiguration getIconTypeForList getDataIcon  %d   listType    %d", idataIcon, ETG_CENUM(entListType, listType)));
   return idataIcon;
}


bool ListConfiguration::getPreviousButtonAvilability(EnumConst::entListType listType)
{
   bool bPrevButtonAvail = false;
   if (isListTypeAvailable(listType))
   {
      bPrevButtonAvail = m_listTypeToListConfig[listType].isPrevButtonAvailable;
   }

   ETG_TRACE_USR4(("ListConfiguration getPreviousButtonAvilability bPrevButtonAvail  %d    listType    %d", bPrevButtonAvail, ETG_CENUM(entListType, listType)));
   return bPrevButtonAvail;
}


bool ListConfiguration::getAllButtonAvilability(EnumConst::entListType listType)
{
   bool bAllButtonAvail = false;
   if (isListTypeAvailable(listType))
   {
      bAllButtonAvail = m_listTypeToListConfig[listType].isAllButtonAvailable;
   }
   ETG_TRACE_USR4(("ListConfiguration getAllButtonAvilability getDataIcon  %d  listType  %d", bAllButtonAvail, ETG_CENUM(entListType, listType)));
   return bAllButtonAvail;
}


int ListConfiguration::getTabGroup(EnumConst::entListType listType)
{
   int tabGroup = 0;
   if (isListTypeAvailable(listType))
   {
      tabGroup = m_listTypeToListConfig[listType].tabGroup;
   }

   ETG_TRACE_USR4(("ListConfiguration::getTabGroup:tabGropup %d  listType  %d ", tabGroup, ETG_CENUM(entListType, listType)));
   return tabGroup;
}


EnumConst::entListType ListConfiguration::getPreviousListType(EnumConst::entListType listType)
{
   EnumConst::entListType prevListType = EnumConst::entListType_Invalid;
   if (isListTypeAvailable(listType))
   {
      prevListType = m_listTypeToListConfig[listType].prevListType;
   }

   ETG_TRACE_USR4(("ListConfiguration::getPreviousListType:prevListType %d   listType    %d", ETG_CENUM(entListType, prevListType), ETG_CENUM(entListType, listType)));

   return prevListType;
}


EnumConst::entListType ListConfiguration::getNextListType(EnumConst::entListType listType)
{
   EnumConst::entListType nxtListType = EnumConst::entListType_Invalid;
   if (isListTypeAvailable(listType))
   {
      nxtListType = m_listTypeToListConfig[listType].nextListType;
   }

   ETG_TRACE_USR4(("ListConfiguration::getNextListType:nextListType %d  listType    %d ", ETG_CENUM(entListType, nxtListType), ETG_CENUM(entListType, listType)));

   return nxtListType;
}


EnumConst::entListType ListConfiguration::getAllListType(EnumConst::entListType listType)
{
   EnumConst::entListType allListType = EnumConst::entListType_Invalid;
   if (isListTypeAvailable(listType))
   {
      allListType = m_listTypeToListConfig[listType].allListType;
   }

   ETG_TRACE_USR4(("ListConfiguration::getAllListType:allButtonList %d   listType    %d", ETG_CENUM(entListType, allListType), ETG_CENUM(entListType, listType)));

   return allListType;
}


enListSliceRequestType ListConfiguration::getListSliceReqType(EnumConst::entListType listType)
{
   enListSliceRequestType sliceRequestType = EN_WINDOW_SLICE_REQ_TYPE;
   if (isListTypeAvailable(listType))
   {
      sliceRequestType = m_listTypeToListConfig[listType].sliceRequestType;
   }

   ETG_TRACE_USR1(("ListConfiguration getListSliceReqType listType %d, sliceRequestType %d", ETG_CENUM(entListType, listType), ETG_CENUM(enListSliceRequestType, sliceRequestType)));
   return sliceRequestType;
}


int ListConfiguration::requestedSourceId(EnumConst::entListType listType, EnumConst::entSourceType sourceType, int fileType)
{
   int requestedSrcId = SRC_INVALID;
   int requestedContentType = EN_DEFAULT_FILE_CONTENT ;

   if (isListTypeAvailable(listType))
   {
      if ((EnumConst::entListType_Folder_file == listType) || (EnumConst::entListType_Folder == listType))
      {
         if (fileType == EN_AUDIO_FILE_CONTENT)
         {
            requestedContentType = EN_AUDIO_FILE_CONTENT;
         }
         else
         {
            requestedContentType = fileType;
         }
      }
      else
      {
         requestedContentType   = m_listTypeToListConfig[listType].contentType;
      }
      ETG_TRACE_USR4(("ListConfiguration::requestedSourceId:requestedContentType %d  ", requestedContentType));

      if (requestedContentType == EN_AUDIO_FILE_CONTENT)
      {
         if (sourceType == EnumConst::entSourceType_CMP)
         {
            requestedSrcId = SRC_CAMERAPORT1_USB_AUDIO;
         }
         else if (sourceType == EnumConst::entSourceType_CMR)
         {
            requestedSrcId = SRC_CMR1_USB1_AUDIO;
         }
      }
      else if (requestedContentType == EN_VIDEO_FILE_CONTENT)
      {
         if (sourceType == EnumConst::entSourceType_CMP)
         {
            requestedSrcId = SRC_CAMERAPORT1_USB_VIDEO;
         }
         else if (sourceType == EnumConst::entSourceType_CMR)
         {
            requestedSrcId = SRC_CMR1_USB1_VIDEO;
         }
      }
   }
   ETG_TRACE_USR4(("ListConfiguration::requestedSourceId:requestedSrcId %d   listType    %d", requestedSrcId, ETG_CENUM(entListType, listType)));

   return requestedSrcId;
}


}// namespace Core
}// namespace App
