/**************************************************************************************
 * @file         : ExternalMediaStateHandler.cpp
 * @author       : RBEI/ECH2-INF4CV_MediaTeam
 * @addtogroup   : AppHmi_media
 * @brief        :
 * @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 * 		  			Initial Revision.
 **************************************************************************************/

#include "hall_std_if.h"
#include "Core/ListHandling/ExternalMediaListDBManager/ExternalMediaListDBManager.h"
#include "Core/ApplicationSwitchClientHandler/ApplicationSwitchClientHandler.h"
#include "AppHmi_MasterBase/AudioInterface/AudioDefines.h"
#include "Core/SourceSwitch/MediaSourceHandling.h"
#include "Core/ExternalMediaDefines.h"
#include "Core/Utils/DbDownloadMap.h"
#include <bits/stdc++.h>
#include <vector>

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_MEDIA_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_MEDIA
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_MEDIA_"
#define ETG_I_FILE_PREFIX                 App::Core::ExternalMediaListDBManager::
#include "trcGenProj/Header/ExternalMediaListDBManager.cpp.trc.h"
#endif

using namespace ::bosch::cm::di::HmiEmpListInterface;

namespace App {
namespace Core {

ExternalMediaListDBManager* ExternalMediaListDBManager::_externalMediaListDBManagerinstance = NULL;


//parameterised constructor with parameter as ExternalMediaSourceHandler object
ExternalMediaListDBManager::ExternalMediaListDBManager(ExternalMediaSourceHandler* obj)
   : _hmiEmpListInterfaceProxy(HmiEmpListInterfaceProxy::createProxy("HmiEmpListInterfacePort", *this))
   , _externalMediaSourceHandler(NULL)
{
   ETG_TRACE_USR1(("ExternalMediaListDBManager constructor \n"));
   StartupSync::getInstance().registerPropertyRegistrationIF(this, "HmiEmpListInterfacePort");

   _externalMediaSourceHandler = obj;
   registerObservers();

   _externalMediaListDBManagerinstance = this;
}


ExternalMediaListDBManager::~ExternalMediaListDBManager()
{
   ETG_TRACE_USR1(("ExternalMediaListDBManager Destructor \n"));
   removeObservors();
   resetMembers();
   _externalMediaSourceHandler = NULL;
   _externalMediaListDBManagerinstance = NULL;
}


void ExternalMediaListDBManager::resetMembers()
{
   ETG_TRACE_USR1(("ExternalMediaListDBManager resetMembers \n"));
}


void ExternalMediaListDBManager::registerObservers()
{
   ETG_TRACE_USR1(("ExternalMediaListDBManager registerObservers"));

   if (NULL != _externalMediaSourceHandler)
   {
      _externalMediaSourceHandler->addCamportUsbSourceAvailabilityObservor((*this));
   }
}


void ExternalMediaListDBManager::removeObservors()
{
   ETG_TRACE_USR1(("ExternalMediaListDBManager::removeObservors"));
   if (NULL != _externalMediaSourceHandler)
   {
      _externalMediaSourceHandler->removeCamportUsbSourceAvailabilityObservor(*this);
   }
}


void ExternalMediaListDBManager::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("ExternalMediaListDBManager::registerProperties"));
}


void ExternalMediaListDBManager::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("ExternalMediaListDBManager::deregisterProperties"));
}


void ExternalMediaListDBManager::onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("ExternalMediaListDBManager::onUnavailable"));
   if (_hmiEmpListInterfaceProxy && _hmiEmpListInterfaceProxy == proxy)
   {
      _hmiEmpListInterfaceProxy->sendSig_DBStateDeregisterAll();
   }
}


void ExternalMediaListDBManager::onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("ExternalMediaListDBManager::onAvailable"));
   if (_hmiEmpListInterfaceProxy && _hmiEmpListInterfaceProxy == proxy)
   {
      _hmiEmpListInterfaceProxy->sendSig_DBStateRegister(*this);
   }
}


void ExternalMediaListDBManager::onSig_DBStateError(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_DBStateError >& error)
{
   ETG_TRACE_USR1(("ExternalMediaListDBManager::onSig_DBStateError on:eneterd"));
}


void ExternalMediaListDBManager::onSig_DBStateSignal(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_DBStateSignal >& signal)
{
   EnumConst::entSourceType l_sourceType = static_cast<EnumConst::entSourceType>(signal->getSourceType());
   uint8 l_DownloadState = static_cast<uint8>(signal->getDownloadState());
   DbDownloadMap::getInstance().setDbDownloadState(l_sourceType, l_DownloadState);
   DbDownloadMap::getInstance().setDbDownloadRequested(l_sourceType, false);
   updateDBDownloadStatusToObservors(l_DownloadState, l_sourceType);
   ETG_TRACE_USR4(("ExternalMediaListDBManager::onSig_DBStateSignal:m_dbDownloadState %d", l_DownloadState));
}


void ExternalMediaListDBManager::onReqDBDownloadError(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqDBDownloadError >& error)
{
   ETG_TRACE_USR1(("ExternalMediaListDBManager:: onReqDBDownloadError"));
}


void ExternalMediaListDBManager::onReqDBDownloadResponse(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqDBDownloadResponse >& response)
{
   ETG_TRACE_USR1(("ExternalMediaListDBManager:: onReqDBDownloadResponse"));
}


void ExternalMediaListDBManager::onCamportUsbSourceAvailabilityUpdate(int iAvailability)
{
   ETG_TRACE_USR4(("ExternalMediaListDBManager::onCamportUsbSourceAvailabilityUpdate iAvailability %d ", iAvailability));

   if (iAvailability == EN_EXTERNAL_MEDIA_DISCONNECTED)
   {
      DbDownloadMap::getInstance().setDbDownloadState(EnumConst::entSourceType_CMP, EnumConst::entDownloadState_Default);
      DbDownloadMap::getInstance().setDbDownloadRequested(EnumConst::entSourceType_CMP, false);
   }
}


void ExternalMediaListDBManager::registerExternalDBDownloadObservor(IExternalDBDownloadUpdateObservor& imp)
{
   ETG_TRACE_USR1(("ExternalMediaListDBManager::registerExternalDBDownloadObservor entered"));
   ::std::vector< IExternalDBDownloadUpdateObservor* >::const_iterator itr = ::std::find(m_dbDownloadStatusUpdateObservor.begin(), m_dbDownloadStatusUpdateObservor.end(), (&imp));
   if (itr == m_dbDownloadStatusUpdateObservor.end())
   {
      m_dbDownloadStatusUpdateObservor.push_back((&imp));
   }
}


void ExternalMediaListDBManager::deregisterExternalDBDownloadObservor(IExternalDBDownloadUpdateObservor& imp)
{
   ETG_TRACE_USR1(("ExternalMediaListDBManager::deregisterExternalDBDownloadObservor entered"));
   ::std::vector< IExternalDBDownloadUpdateObservor* >::iterator itr = ::std::find(m_dbDownloadStatusUpdateObservor.begin(), m_dbDownloadStatusUpdateObservor.end(), (&imp));
   if (itr != m_dbDownloadStatusUpdateObservor.end())
   {
      (void)m_dbDownloadStatusUpdateObservor.erase(itr);
   }
}


void ExternalMediaListDBManager::updateDBDownloadStatusToObservors(uint8 downloadState, EnumConst::entSourceType sourceType)
{
   ETG_TRACE_USR4(("ExternalMediaListDBManager::updateDBDownloadStatusToObservors downloadState %d", downloadState));
   for (::std::vector< IExternalDBDownloadUpdateObservor* >::const_iterator itr = m_dbDownloadStatusUpdateObservor.begin(); (itr != m_dbDownloadStatusUpdateObservor.end()); ++itr)
   {
      if (NULL != (*itr))
      {
         (*itr)->onExternalDBDownloadUpdate(downloadState, sourceType);
      }
   }
}


void ExternalMediaListDBManager::setDBDownloadState(int dbState, EnumConst::entSourceType sourceType)
{
   DbDownloadMap::getInstance().setDbDownloadState(sourceType, dbState);
}


}// namespace Core
}// namespace App
