/**************************************************************************************
* @file         : EMPListPlaybackHandler..h
* @author       : RBEI/ECH2-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
* 		  			Initial Revision.
**************************************************************************************/

#ifndef _EMPListPlaybackHandler_H_
#define _EMPListPlaybackHandler_H_

#include "AppBase/ServiceAvailableIF.h"
#include "Core/ListHandling/VerticalListManager/VerticalListManager.h"
#include "AvdeccPluginConstant.h"
#include <bits/stdc++.h>

namespace App {
namespace Core {

class EMPListPlaybackHandler
   : public StartupSync::PropertyRegistrationIF
   , public hmibase::ServiceAvailableIF
{
   public:
      EMPListPlaybackHandler(VerticalListManager* _obj, EnumConst::entSourceType currentSourceType, ExternalMediaSourceHandler* _mediaSourceHandler);
      virtual ~EMPListPlaybackHandler();

      void playItemRequest(EnumConst::entListType listType, uint16 absoluteIndex, bool isSameSource, std::string folderPath, int fileType);
      void updateRequestedListItemInfo();
      void onSourceAllocationUpdate();
      void resetMembers();
      void registerObservors();
      void clearInstance();
      //<!--Property registration-->
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

   private:
      VerticalListManager* _verticalListManager;
      ExternalMediaSourceHandler* _externalMediaSourceHandler;
      EnumConst::entListType _requestedListType;
      uint16 _requestedAbsoluteIndex;
      bool _isSourceChangeRequested;
      EnumConst::entSourceType m_currentSourceType;
      std::string _folderPath;
      int _fileType;
};


} // namespace Core
} // namespace App


#endif  /* _EMPListPlaybackHandler_H_ */
