/**************************************************************************************
 * @file         : MockEMPListInterfaceHandler.cpp
 * @author       : RBEI/ECH2-INF4CV_MediaTeam
 * @addtogroup   : AppHmi_media
 * @brief        :
 * @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 * 		  			Initial Revision.
 **************************************************************************************/

#include "hall_std_if.h"
#include "MockEMPListInterfaceHandler.h"
#include "Core/ListHandling/ListInfoDatabaseHandler/ListInfoDatabaseHandler.h"
#include "Core/StateTransitionHandler/StateTransitionHandler.h"
#include "Core/ListHandling/ListContainer/ListContainer.h"
#include "Core/ListHandling/VerticalListManager/VerticalListManager.h"
#include "Core/ApplicationSwitchClientHandler/ApplicationSwitchClientHandler.h"
#include "AppHmi_MasterBase/AudioInterface/AudioDefines.h"
#include <vector>
#include <string>


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_MEDIA_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_MEDIA
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_MEDIA_"
#define ETG_I_FILE_PREFIX                 App::Core::ListHandling::EMPListInterfaceHandler::
#include "trcGenProj/Header/MockEMPListInterfaceHandler.cpp.trc.h"
#endif

//using namespace ::bosch::cm::di::HmiEmpListInterface;

namespace App {
namespace Core {

MockEMPListInterfaceHandler::MockEMPListInterfaceHandler(VerticalListManager* _obj, ListContainer* _container, ListInfoDatabaseHandler* _listInfoDBHandler)
{
   ETG_TRACE_USR1(("EMPListInterfaceHandler constructor "));

   _verticalListManagerObj = _obj;
   _containerObj = _container;
   _listInfoDBHandlerObj = _listInfoDBHandler;
   m_requestedlistType = EnumConst::entListType_Invalid;
   m_currentSourceType = EnumConst::entSourceType_CMP;
   m_currentActiveRegion = REGION_INVALID;
   _currentListSize = 0;
   registerObservors();
}


MockEMPListInterfaceHandler::~MockEMPListInterfaceHandler()
{
   deregisterObservors();
   ETG_TRACE_USR1(("MockEMPListInterfaceHandler Destructor \n"));
}


void MockEMPListInterfaceHandler::registerObservors()
{
   ETG_TRACE_USR4(("MockEMPListInterfaceHandler:: registerObservors "));
   HmiEmpListInterface::getInstance().registerEmpListSizeObserver((this));
   HmiEmpListInterface::getInstance().registerEmpListContainerObserver((this));
}


void MockEMPListInterfaceHandler::deregisterObservors()
{
   ETG_TRACE_USR4(("MockEMPListInterfaceHandler:: deregisterObservors "));
   HmiEmpListInterface::getInstance().deregisterEmpListSizeObserver((this));
   HmiEmpListInterface::getInstance().deregisterEmpListContainerObserver((this));
}


void MockEMPListInterfaceHandler::onCreateMediaPlayerListError()
{
   ETG_TRACE_USR1(("MockEMPListInterfaceHandler::onCreateMediaPlayerListError"));
}


void MockEMPListInterfaceHandler::onCreateMediaPlayerListResult()
{
   // bool bListresp = response->getResponse();
   ETG_TRACE_USR4(("MockEMPListInterfaceHandler::onCreateMediaPlayerListResult"));
}


void MockEMPListInterfaceHandler::onCreateMediaPlayerFolderListError()
{
   ETG_TRACE_COMP(("MockEMPListInterfaceHandler::onCreateMediaPlayerFolderListError"));
}


void MockEMPListInterfaceHandler::onCreateMediaPlayerFolderListResult()
{
   ETG_TRACE_COMP(("MockEMPListInterfaceHandler::onCreateMediaPlayerFolderListResult"));
}


void MockEMPListInterfaceHandler::createListRequest(EnumConst::entListType listType,  uint16 absoluteIndex1, uint16 absoluteIndex2)
{
   ETG_TRACE_USR4(("MockEMPListInterfaceHandler::createListRequest listType   absoluteIndex1 absoluteIndex2 %d %d %d", listType, absoluteIndex1, absoluteIndex2));
   uint8 u8ActiveRegion = ApplicationSwitchClientHandler::poGetInstance()->getActiveRegion();
   ETG_TRACE_USR4(("EMPListInterfaceHandler::createListRequest u8ActiveRegion %d, ", u8ActiveRegion));
   m_requestedlistType = listType;
   m_currentActiveRegion = u8ActiveRegion;
   HmiEmpListInterface::getInstance().sendReqCreateMediaPlayerListRequest(*this, m_requestedlistType, m_currentSourceType, u8ActiveRegion, absoluteIndex1, absoluteIndex2);
}


void MockEMPListInterfaceHandler::createListRequest(EnumConst::entListType listType, std::string folderPath)
{
   uint8 u8ActiveRegion = ApplicationSwitchClientHandler::poGetInstance()->getActiveRegion();
   m_requestedlistType = listType;
   ETG_TRACE_USR1(("MockEMPListInterfaceHandler::createListRequest: u8ActiveRegion: %d, folderPath: %s", u8ActiveRegion, folderPath.c_str()));
   HmiEmpListInterface::getInstance().sendReqCreateMediaPlayerFolderListRequest(*this, m_currentSourceType, u8ActiveRegion, folderPath);
}


//
//void MockEMPListInterfaceHandler::onListSizeError()
//{
//   ETG_TRACE_USR1(("MockEMPListInterfaceHandler::onListSizeError Entered"));
//}


void MockEMPListInterfaceHandler::onListSizeUpdate(ListSizeStruct strListSize)
{
   //if (m_bMockActive == true)
   //{
   _currentListSize = strListSize.Count;
   //EnumConst::entListType listType = static_cast <EnumConst::entListType>(m_requestedlistType);
   //_listInfoDBHandlerObj->updateCurrentListSize(listType, _currentListSize);
   ETG_TRACE_USR4(("MockEMPListInterfaceHandler::onListSizeUpdate m_currentListSize  %d", _currentListSize));

   //_verticalListManagerObj->onListCreateResponse();
   //}
}


void MockEMPListInterfaceHandler::onListContainerUpdate(std::vector<ListContainerStruct> strListContainer)
{
   _listContainer.clear();
   _listContainer = strListContainer;
   ETG_TRACE_USR4(("MockEMPListInterfaceHandler::onListContainerUpdate: size: %d", _listContainer.size()));
   for (int index = 0; index < _listContainer.size(); ++index)
   {
      ETG_TRACE_USR4(("MockEMPListInterfaceHandler::onListContainerUpdate: %s", (_listContainer[index].Text1).c_str()));
      absoluteIndex.push_back(_listContainer[index].AbsoluteIndex);
   }
}


void MockEMPListInterfaceHandler::sliceListRequest(EnumConst::entListType listType, uint16 startIndex, uint16 windowSize, uint16 absoluteIndex1, uint16 absoluteIndex2)
{
   ETG_TRACE_USR4(("MockEMPListInterfaceHandler::sliceListRequest listType startIndex windowSize   %d  %d   %d", listType, startIndex, windowSize));
   uint8 u8ActiveRegion = ApplicationSwitchClientHandler::poGetInstance()->getActiveRegion();
   HmiEmpListInterface::getInstance().sendReqMediaPlayerListSliceRequest(*this, listType, m_currentSourceType, u8ActiveRegion, startIndex, windowSize, absoluteIndex1, absoluteIndex2);
}


void MockEMPListInterfaceHandler::sliceListRequest(uint16 startIndex, uint16 windowSize, std::string folderPath)
{
   uint8 u8ActiveRegion = ApplicationSwitchClientHandler::poGetInstance()->getActiveRegion();
   ETG_TRACE_USR1(("MockEMPListInterfaceHandler::sliceListRequest: startIndex %d, windowSize %d, folderPath: %s", startIndex, windowSize, folderPath.c_str()));
   HmiEmpListInterface::getInstance().sendReqMediaPlayerFolderListSliceRequest(*this, m_currentSourceType, u8ActiveRegion, startIndex, windowSize, folderPath);
}


void MockEMPListInterfaceHandler::updateSelectedLanguageList()
{
   ETG_TRACE_USR1(("MockEMPListInterfaceHandler::updateSelectedLanguageList"));
   uint8 region = ApplicationSwitchClientHandler::poGetInstance()->getActiveRegion();
   std::vector<uint16> selectedLanguagesId = _containerObj->getSelectedLanguageId();
   HmiEmpListInterface::getInstance().sendSetMediaVideoLanguagesListRequest(*this, region, selectedLanguagesId);
}


void MockEMPListInterfaceHandler::onRequestMediaPlayerListSliceError()
{
   ETG_TRACE_USR1(("MockEMPListInterfaceHandler::onRequestMediaPlayerListSliceError Entered"));
}


//void MockEMPListInterfaceHandler::onReqMediaPlayerListSliceResponse()
//{
//  ETG_TRACE_USR1(("EMPListInterfaceHandler::onReqMediaPlayerListSliceResponse Entered"));
//
//   ::std::vector<ListContainerStruct> _listContainer = response->getMArrayListContainer();
//
//   //_containerObj->setContainer(_listContainer);
//   //_containerObj->m_strListContainer = _listContainer;
//
//   std::vector<ListContainerStruct> _listContainer =
//   updateFirstTextToContainer(_listContainer);
//   updateSecondTextToContainer(_listContainer);
//   updateAbsoluteIndexToContainer(_listContainer);
////   _verticalListManagerObj->onListSliceResponse();
//}


void MockEMPListInterfaceHandler::onRequestMediaPlayerListSliceResult(std::vector<ListContainerStruct> listStruct)
{
   ETG_TRACE_USR1(("EMPListInterfaceHandler::onReqMediaPlayerListSliceResponse Entered"));
   //std::vector<ListContainerStruct> _listContainer = listStruct;

   //_containerObj->setContainer(_listContainer);
   //_containerObj->m_strListContainer = _listContainer;
   //updateFirstTextToContainer(_listContainer);
   //updateSecondTextToContainer(_listContainer);
   //updateAbsoluteIndexToContainer(_listContainer);
   //_verticalListManagerObj->onListSliceResponse();
}


void MockEMPListInterfaceHandler::onRequestMediaPlayerFolderListSliceError()
{
   ETG_TRACE_USR1(("MockEMPListInterfaceHandler::onRequestMediaPlayerFolderListSliceError Entered"));
}


void MockEMPListInterfaceHandler::onRequestMediaPlayerFolderListSliceResult()
{
   ETG_TRACE_USR1(("MockEMPListInterfaceHandler::onRequestMediaPlayerFolderListSliceResult Entered"));
}


void MockEMPListInterfaceHandler::onMediaVideoLanguagesListError()
{
   ETG_TRACE_USR1(("MockEMPListInterfaceHandler::onMediaVideoLanguagesListError Entered"));
}


void MockEMPListInterfaceHandler::onMediaVideoLanguagesListResponse()
{
   ETG_TRACE_USR1(("EMPListInterfaceHandler::onMediaVideoLanguagesListResponse Entered"));
}


void MockEMPListInterfaceHandler::updateFirstTextToContainer(std::vector<ListContainerStruct> _listContainer)
{
   ETG_TRACE_USR1(("EMPListInterfaceHandler::updateFirstTextToContainer Entered"));

   std::vector<std::string> metadataList;

   for (int index = 0; index < _listContainer.size(); ++index)
   {
      metadataList.push_back(_listContainer[index].Text1);
      ETG_TRACE_USR4(("MockEMPListInterfaceHandler::updateFirstTextToContainer:  %s", (_listContainer[index].Text1).c_str()));
   }
   _containerObj->setFirstTextOfList(metadataList);
}


void MockEMPListInterfaceHandler::updateSecondTextToContainer(std::vector<ListContainerStruct> _listContainer)
{
   ETG_TRACE_USR1(("EMPListInterfaceHandler::updateSecondTextToContainer Entered"));

   std::vector<std::string> metadataList;

   for (int index = 0; index < _listContainer.size(); ++index)
   {
      metadataList.push_back(_listContainer[index].Text2);
   }
   _containerObj->setSecondTextOfList(metadataList);
}


void MockEMPListInterfaceHandler::updateAbsoluteIndexToContainer(std::vector<ListContainerStruct> _listContainer)
{
   ETG_TRACE_USR1(("EMPListInterfaceHandler::updateSecondTextToContainer Entered"));

   std::vector<uint16> absoluteIndex;

   for (int index = 0; index < _listContainer.size(); ++index)
   {
      absoluteIndex.push_back(_listContainer[index].AbsoluteIndex);
   }
   _containerObj->setAbsoluteIndex(absoluteIndex);
}


void MockEMPListInterfaceHandler::updateLanguageSelectionStatusToContainer(std::vector<ListContainerStruct> _listContainer)
{
   ETG_TRACE_COMP(("EMPListInterfaceHandler::updateLanguageSelectionStatusToContainer vector size  %d", _listContainer.size()));

   std::vector<bool> isLanguageSelected;

   for (int index = 0; index < _listContainer.size(); ++index)
   {
      isLanguageSelected.push_back(_listContainer[index].IsSelectedLanguage);
   }
   _containerObj->setIsLanguageSelected(isLanguageSelected);
}


void MockEMPListInterfaceHandler::updateFileTypeToContainer(std::vector<ListContainerStruct> _listContainer)
{
   ETG_TRACE_COMP(("EMPListInterfaceHandler::updateFileTypeToContainer vector size  %d", _listContainer.size()));

   std::vector<bosch::cm::di::HmiEmpListInterface::entFileType> fileType;

   for (int index = 0; index < _listContainer.size(); ++index)
   {
      fileType.push_back(_listContainer[index].FileType);
   }
   _containerObj->setFileType(fileType);
}


bool MockEMPListInterfaceHandler::onCourierMessage(const MockCreateListandSliceListResMsg& oMsg)
{
   ETG_TRACE_USR1(("EMPListInterfaceHandler::CreateListandSliceListResMsg absoluteIndex  %d", oMsg.GetListState()));
   switch (oMsg.GetListState())
   {
      case EN_LIST_RESPONSE_STATE_CREATELIST:
      {
         ETG_TRACE_USR1(("EMPListInterfaceHandler::CreateListandSliceListResMsg m_requestedlistType  %d", m_requestedlistType));
         ETG_TRACE_USR1(("EMPListInterfaceHandler::CreateListandSliceListResMsg _currentListSize  %d", _currentListSize));
         _listInfoDBHandlerObj->updateCurrentListSize(m_requestedlistType, _currentListSize);
         _verticalListManagerObj->onListCreateResponse();
         break;
      }
      case EN_LIST_RESPONSE_STATE_SLICELIST:
      {
         updateFirstTextToContainer(_listContainer);
         updateSecondTextToContainer(_listContainer);
         updateAbsoluteIndexToContainer(_listContainer);
         updateLanguageSelectionStatusToContainer(_listContainer);
         updateFileTypeToContainer(_listContainer);
         _verticalListManagerObj->onListSliceResponse();
         _listInfoDBHandlerObj->updateAbsoluteIndex(m_requestedlistType, absoluteIndex);

         break;
      }
   }
   return false;
}


}// namespace Core
}// namespace App
