/**************************************************************************************
* @file         : IEMPListHandler.h
* @author       : RBEI/ECG5-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#ifndef IEMPListHandler_h
#define IEMPListHandler_h

#include "AppBase/ServiceAvailableIF.h"
#include "AvdeccPluginConstant.h"

namespace App {
namespace Core {

class IEMPListHandler
{
   public:

      IEMPListHandler();
      virtual ~IEMPListHandler();

      virtual void createListRequest(EnumConst::entListType listType,  uint16 absoluteIndex1, uint16 absoluteIndex2) = 0;
      virtual void sliceListRequest(EnumConst::entListType listType, uint16 startIndex, uint16 windowSize, uint16 absoluteIndex1, uint16 absoluteIndex2) = 0;
      virtual void createListRequest(EnumConst::entListType listType, std::string folderPath) = 0;
      virtual void sliceListRequest(uint16 startIndex, uint16 windowSize, std::string folderPath) = 0;
      virtual void updateSelectedLanguageList() = 0;
};


} // namespace Core
} // namespace App
#endif
