/**************************************************************************************
* @file         : EMPListInterfaceHandler..h
* @author       : RBEI/ECH2-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
* 		  			Initial Revision.
**************************************************************************************/

#ifndef _EMPListInterfaceHandler_H_
#define _EMPListInterfaceHandler_H_

#include "AppBase/ServiceAvailableIF.h"
#include "AppHmi_MediaStateMachine.h"
#include "Core/ListHandling/VerticalListManager/VerticalListManager.h"
#include "AppHmi_MediaDatabinding.h"
//#include "AvdeccPluginConstant.h"
#include "Core/ExternalMediaDefines.h"
#include "bosch/cm/di/HmiEmpListInterfaceProxy.h"
#include "Core/ListHandling/EMPListInterfaceHandler/IEMPListHandler.h"
#include <bits/stdc++.h>
#include "bosch/cm/di/HmiEmpListInterfaceProxy.h"

namespace App {
namespace Core {

class ListContainer;
class ListInfoDatabaseHandler;

class EMPListInterfaceHandler
   : public StartupSync::PropertyRegistrationIF
   , public hmibase::ServiceAvailableIF
   , public ::bosch::cm::di::HmiEmpListInterface::ReqCreateMediaPlayerListCallbackIF
   , public ::bosch::cm::di::HmiEmpListInterface::ListSizeCallbackIF
   , public ::bosch::cm::di::HmiEmpListInterface::ReqMediaPlayerListSliceCallbackIF
   , public ::bosch::cm::di::HmiEmpListInterface::ReqCreateMediaPlayerFolderListCallbackIF
   , public ::bosch::cm::di::HmiEmpListInterface::ReqMediaPlayerFolderListSliceCallbackIF
   , public IEMPListHandler
   , public ::bosch::cm::di::HmiEmpListInterface::SetMediaVideoLanguagesListCallbackIF
{
   public:

      EMPListInterfaceHandler(VerticalListManager* _obj, ListContainer* _container,
                              ListInfoDatabaseHandler* _listInfoDBHandlerObj, EnumConst::entSourceType currentSourceType);
      virtual ~EMPListInterfaceHandler();

      void createListRequest(EnumConst::entListType listType, uint16 absoluteIndex1, uint16 absoluteIndex2);
      void createListRequest(EnumConst::entListType listType, std::string folderPath);
      void sliceListRequest(EnumConst::entListType listType, uint16 startIndex, uint16 windowSize, uint16 absoluteIndex1, uint16 absoluteIndex2);
      EnumConst::entSourceType getCurrentSourceType();
      void sliceListRequest(uint16 startIndex, uint16 windowSize, std::string folderPath);

      void resetMembers();
      void updateSelectedLanguageList();

      //<!--Property registration-->
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      virtual void onReqCreateMediaPlayerListError(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqCreateMediaPlayerListError >& error);
      virtual void onReqCreateMediaPlayerListResponse(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqCreateMediaPlayerListResponse >& response);

      virtual void onReqCreateMediaPlayerFolderListError(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqCreateMediaPlayerFolderListError >& error);
      virtual void onReqCreateMediaPlayerFolderListResponse(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqCreateMediaPlayerFolderListResponse >& response);

      virtual void onListSizeError(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< ListSizeError >& error);
      virtual void onListSizeUpdate(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< ListSizeUpdate >& update);

      virtual void onReqMediaPlayerListSliceError(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqMediaPlayerListSliceError >& error);
      virtual void onReqMediaPlayerListSliceResponse(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqMediaPlayerListSliceResponse >& response);

      virtual void onReqMediaPlayerFolderListSliceError(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqMediaPlayerFolderListSliceError >& error);
      virtual   void onReqMediaPlayerFolderListSliceResponse(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqMediaPlayerFolderListSliceResponse >& response);

      virtual void onSetMediaVideoLanguagesListError(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy,
            const ::boost::shared_ptr< SetMediaVideoLanguagesListError >& error);
      virtual void onSetMediaVideoLanguagesListResponse(const ::boost::shared_ptr< HmiEmpListInterfaceProxy >& proxy,
            const ::boost::shared_ptr< SetMediaVideoLanguagesListResponse >& update);

   private:
      ListContainer* _listDataContainer;
      ListInfoDatabaseHandler* _listInfoDBHandler;
      VerticalListManager* _verticalListManager;

      EnumConst::entListType m_requestedlistType;
      EnumConst::entSourceType m_currentSourceType;
      uint16 _startIndex;
      void updateFirstTextToContainer(std::vector<bosch::cm::di::HmiEmpListInterface::ListContainerStruct>& listContainer);
      void updateSecondTextToContainer(std::vector<bosch::cm::di::HmiEmpListInterface::ListContainerStruct>& listContainer);
      void updateAbsoluteIndexToContainer(std::vector<bosch::cm::di::HmiEmpListInterface::ListContainerStruct>& listContainer);
      void updateLanguageSelectionStatusToContainer(std::vector<bosch::cm::di::HmiEmpListInterface::ListContainerStruct>& listContainer);
      ::boost::shared_ptr<HmiEmpListInterfaceProxy> _hmiEmpListInterfaceProxy;
      void updateAbsoluteIndexToDBHandler(std::vector<bosch::cm::di::HmiEmpListInterface::ListContainerStruct>& listContainer);
      void updateFileTypeToContainer(std::vector<bosch::cm::di::HmiEmpListInterface::ListContainerStruct>& listContainer);
};


} // namespace Core
} // namespace App


#endif  /* _EMPListInterfaceHandler_H_ */
