/**************************************************************************************
 * @file         : KDSHandler.cpp
 * @author       : RBEI/ECG5-INF4CV_MediaTeam
 * @addtogroup   : AppHmi_media
 * @brief        :
 * @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant

 *******************************************************************************/
#include "hall_std_if.h"
#include "Core/KDSHandler/KDSHandler.h"
#include "Core/MediaDefines.h"
#include "Core/VehicleSrvClient/VehicleSrvClient.h"
#include "DataModel/HMIModelComponent.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_MEDIA_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_MEDIA
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_MEDIA_"
#define ETG_I_FILE_PREFIX                 App::Core::KDSHandler::
#include "trcGenProj/Header/KDSHandler.cpp.trc.h"
#endif

#ifdef DP_DATAPOOL_ID
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#endif


namespace App {
namespace Core {

/************************************************************************
*FUNCTION		: KDSHandler
*DESCRIPTION	: Constructor. Initializes the member variables.
*PARAMETER		:
*PARAMETER		:
*RETURNVALUE	: NA
************************************************************************/
KDSHandler::KDSHandler()
{
   m_UsbCamportKdsValue = 0xFF;
   readUsbCamportKdsValue();
   _regionType = 0;
   readKdsForRegion();
   _HDMIKdsValue = 0;
   readHdmiKDSValue();
   _getHubConfig = 2;
   readHubKDSValue();
   readAuxKdsValue();
}


/************************************************************************
*FUNCTION		: KDSHandler
*DESCRIPTION	: Destructor.
*PARAMETER		:
*RETURNVALUE	: NA
************************************************************************/
KDSHandler::~KDSHandler()
{
}


/************************************************************************
*FUNCTION		: readUsbCamportKdsValue
*DESCRIPTION	: Reads the KDS parameter value for handling the visibility of usbcamport in Cabin.
*PARAMETER		:
*PARAMETER		:
*RETURNVALUE	: NA
************************************************************************/
void KDSHandler::readUsbCamportKdsValue()
{
   uint8 isCamportUSBAvailable = 0;
   if (DP_S32_NO_ERR == DP_s32GetConfigItem("CIS_Configuration", "CameraportUSB", &isCamportUSBAvailable, 1))
   {
      ETG_TRACE_USR4(("VariantHandling::readKDSCMPUSBAvailability::%d", isCamportUSBAvailable));
      m_UsbCamportKdsValue = isCamportUSBAvailable;
   }

   ETG_TRACE_USR4(("KDSHandler::readUsbCamportKdsValue m_UsbCamportKdsValue : %d,  isCamportUSBAvailable  %d", m_UsbCamportKdsValue, isCamportUSBAvailable));
}


bool KDSHandler::getUsbCamportKdsValue()
{
   bool camportUSBAvailable = ((m_UsbCamportKdsValue == 0XFF) || (m_UsbCamportKdsValue == 0)) ? false : true;
   ETG_TRACE_USR4(("KDSHandler::getUsbCamportKdsValue m_UsbCamportKdsValue %d camportUSBAvailable   %d", m_UsbCamportKdsValue, camportUSBAvailable));
   return camportUSBAvailable;
}


/************************************************************************

*FUNCTION		: readKdsForRegion

*DESCRIPTION	: reading region for nafta /europe to hide ta announcement button checkbox in settings screen

*PARAMETER		: NA

*PARAMETER		: NA

*RETURNVALUE	: void

************************************************************************/

void KDSHandler::readKdsForRegion()
{
   uint8 regionType = 0;
   if (DP_S32_NO_ERR == DP_s32GetConfigItem("VehicleInformation", "DestinationRegion1", &regionType, 1))
   {
      ETG_TRACE_USR4(("KDSHandler::readKdsForRegion::%d", regionType));
      _regionType = regionType;
   }
   else
   {
      ETG_TRACE_USR4(("KDSHandler::readKdsForRegion::Datapool read error"));
   }
}


uint8 KDSHandler::getRegionID()
{
   return _regionType;
}


/************************************************************************
*FUNCTION		: readHdmiKDSValue
*DESCRIPTION	: Reads the KDS parameter value for handling the visibility of hdmi in Cabin.
*PARAMETER		:
*PARAMETER		:
*RETURNVALUE	: NA
************************************************************************/
void KDSHandler::readHdmiKDSValue()
{
   uint8 isHDMIAvailable = 0;
   if (DP_S32_NO_ERR == DP_s32GetConfigItem("AIVIVariantCoding", "HDMIApp", &isHDMIAvailable, 1))
   {
      ETG_TRACE_USR1(("KDSHandler::readHdmiKDSValue::%d", isHDMIAvailable));
      _HDMIKdsValue = isHDMIAvailable;
   }
   ETG_TRACE_USR4(("KDSHandler::readHdmiKDSValue _HDMIKdsValue : %d,  isHDMIAvailable  %d", _HDMIKdsValue, isHDMIAvailable));
}


int KDSHandler::getHdmiKDSValue()
{
   ETG_TRACE_USR4(("KDSHandler::getHdmiKDSValue _HDMIKdsValue %d ", _HDMIKdsValue));

   return _HDMIKdsValue;
}


/************************************************************************
*FUNCTION		: readHubKDSValue
*DESCRIPTION	: Reads the KDS parameter value for hub configuration in Cabin.
*PARAMETER		:
*PARAMETER		:
*RETURNVALUE	: NA
************************************************************************/
void KDSHandler::readHubKDSValue()
{
   uint8 iHubConfigValue = 0;
   if (DP_S32_NO_ERR == DP_s32GetConfigItem("SystemConfiguration1", "MCH1MountInformation", &iHubConfigValue, 1))
   {
      ETG_TRACE_USR4(("tclMediaClientHandler::tclMediaClientHandler() : _videoTimer Fail :- Hub configuration "));
   }
   if (iHubConfigValue == 1) // config 1 port Hub  ,otherwise always 2 port Hub
   {
      _getHubConfig = iHubConfigValue;
   }

   ETG_TRACE_USR4(("KDSHandler::readUsbCamportKdsValue _getHubConfig : %d,  iHubConfigValue  %d", _getHubConfig, iHubConfigValue));
}


int KDSHandler::getHubKDSValue()
{
   ETG_TRACE_USR4(("KDSHandler::getHubKDSValue _getHubConfig %d ", _getHubConfig));

   return _getHubConfig;
}


/************************************************************************
*FUNCTION		: readAuxKdsValue
*DESCRIPTION	: Reads the KDS parameter value for handling the visibility of usbcamport in Cabin.
*PARAMETER		:
*PARAMETER		:
*RETURNVALUE	: NA
***********************************************************************/
void KDSHandler::readAuxKdsValue()
{
   tU8 iAuxKdsValue = 0;
   if (DP_S32_NO_ERR ==  DP_s32GetConfigItem("SystemConfiguration1", "AUX", &iAuxKdsValue, 1))
   {
      ETG_TRACE_USR4(("KDSHandler::readAuxKdsValue::%d", iAuxKdsValue));
   }
   if (iAuxKdsValue == 0) //if value is 0
   {
      g_SM_VARIANT_AUX = 0;
      HMIModelComponent::getInstance().vAuxSourceVisibility(false);
   }
   else
   {
      g_SM_VARIANT_AUX = 1;
      HMIModelComponent::getInstance().vAuxSourceVisibility(true);
   }
}


}//end of namespace Core
}//end of namespace App
