/**************************************************************************************
* @file         : HmiStateHandler.h
* @author       : RBEI/ECG5-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        : HmiStateHandler is to handle HALL implementation for
*                 SPM_CORE_FI service
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#ifndef HMI_STATE_HANDLER_H
#define HMI_STATE_HANDLER_H

#include "SPM_CORE_FIProxy.h"

using namespace ::asf::core;

namespace App {
namespace Core {

class IHmiStateStatusObserver
{
   public:
      IHmiStateStatusObserver() {}
      virtual ~IHmiStateStatusObserver() {}
      virtual void onHmiStateUpdate(uint8 currentHmiState) = 0;
};


class HmiStateHandler : public ServiceAvailableIF,
   public StartupSync::PropertyRegistrationIF,
   public SPM_CORE_FI::HmiStateCallbackIF
{
   public:
      HmiStateHandler();
      virtual ~HmiStateHandler();

      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

      virtual void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      virtual void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      void onHmiStateError(const ::boost::shared_ptr< SPM_CORE_FI::SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SPM_CORE_FI::HmiStateError >& error);
      void onHmiStateStatus(const ::boost::shared_ptr< SPM_CORE_FI::SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SPM_CORE_FI::HmiStateStatus >& status);

      void addHmiStateStatusObserver(IHmiStateStatusObserver& imp);
      void removeHmiStateStatusObserver(IHmiStateStatusObserver& imp);
      void notifyHmiStateStatusListeners(uint8 currentHmiState);
   private:
      ::boost::shared_ptr< ::SPM_CORE_FI::SPM_CORE_FIProxy > _spmProxy;
      std::vector<IHmiStateStatusObserver* > _hmiStateStatusListener;
};


}
}


#endif
