/**************************************************************************************
 * @file         : ExternalMediaStateHandler.cpp
 * @author       : RBEI/ECH2-INF4CV_MediaTeam
 * @addtogroup   : AppHmi_media
 * @brief        :
 * @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 * 		  			Initial Revision.
 **************************************************************************************/

#include "hall_std_if.h"
#include "Core/ExternalMediaStateHandler/ExternalMediaStateHandler.h"
#include "AppHmi_MasterBase/AudioInterface/AudioDefines.h"
#include <vector>

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_MEDIA_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_MEDIA
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_MEDIA_"
#define ETG_I_FILE_PREFIX                 App::Core::ExternalMediaStateHandler::
#include "trcGenProj/Header/ExternalMediaStateHandler.cpp.trc.h"
#endif

namespace App {
namespace Core {

/**
	* Description     : Constructor of class ExternalMediaSourceHandler
	*/
ExternalMediaStateHandler::ExternalMediaStateHandler()

{
   ETG_TRACE_USR1(("ExternalMediaStateHandler::ExternalMediaStateHandler constructor \n"));
}


ExternalMediaStateHandler::~ExternalMediaStateHandler()
{
   ETG_TRACE_USR1(("ExternalMediaListDBManager::ExternalMediaStateHandler Destructor \n"));
}


void ExternalMediaStateHandler::onCamportUsbSourceAvailabilityUpdate(int iAvailability)
{
   ETG_TRACE_USR1(("ExternalMediaStateHandler::onCamportUsbVideoSourceAvailabilityUpdate iAvailability %d ", iAvailability));
}


}// namespace Core
}// namespace App
