/**************************************************************************************
* @file         : ExternalMediaSourceStateUpdateHandler.h
* @author       : RBEI/ECG5-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef _EXTERNAL_MEDIASOURCE_STATE_UPDATE_HANDLER_H_
#define _EXTERNAL_MEDIASOURCE_STATE_UPDATE_HANDLER_H_

#include "bosch/cm/ai/hmi/hmiinfoservice/HmiInfoServiceProxy.h"
#include "AppBase/ServiceAvailableIF.h"
#include "Core/Utils/ExternalMediaSourceConnectionStatus.h"
#include "Core/ExternalMediaSourceConnectionStateHandler/ExternalMediaSourceConnectionStateHandler.h"
#include <vector>
#include <iterator>

/*struct CabinSrcConnectionStatusInfo
{
   int16 sourceId;
   bool status;
};*/


class StartupSync;

namespace App {
namespace Core {

class ExternalMediaSourceStateUpdateHandler : public hmibase::ServiceAvailableIF, public IExternalSourceAvailabilityStatusObserver,
   public StartupSync::PropertyRegistrationIF,
   public SetCabinSourceConnectionStatusCallbackIF
{
   public:
      ExternalMediaSourceStateUpdateHandler();
      virtual ~ExternalMediaSourceStateUpdateHandler();

      void setExternalMediaSourceConnectionStatusInstance(ExternalMediaSourceConnectionStatus* _externalMediaSourceConnectionStatusInstance);
      void setExternalMediaSourceConnectionStateHandlerInstance(ExternalMediaSourceConnectionStateHandler* _externalMediaSourceConnectionStateHandlerInstance);

      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      virtual void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      virtual void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      virtual void onSetCabinSourceConnectionStatusError(const ::boost::shared_ptr< HmiInfoServiceProxy >& /*proxy*/,
            const ::boost::shared_ptr< SetCabinSourceConnectionStatusError >& error);
      virtual void onSetCabinSourceConnectionStatusResponse(const ::boost::shared_ptr< HmiInfoServiceProxy >& /*proxy*/,
            const ::boost::shared_ptr< SetCabinSourceConnectionStatusResponse >& update);

      void onExternalSourceAvailabilityUpdate();

   private:
      ::boost::shared_ptr< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::HmiInfoServiceProxy> _hmiInfoServiceProxyClient;
      ExternalMediaSourceConnectionStateHandler* _externalMediaSourceConnectionStateHandler;
      ExternalMediaSourceConnectionStatus* _externalMediaSourceConnectionStatus;
};


} // namespace Core
} // namespace App


#endif  /* _EXTERNAL_MEDIASOURCE_STATE_UPDATE_HANDLER_H_*/
