/**************************************************************************************
* @file         : ExternalMediaSourceStateUpdateHandler.cpp
* @author       : RBEI/ECG5-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "hall_std_if.h"
#include "Core/ExternalMediaSourceStateUpdateHandler/ExternalMediaSourceStateUpdateHandler.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_MEDIA_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_MEDIA
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_MEDIA_"
#define ETG_I_FILE_PREFIX                 App::Core::ExternalMediaSourceStateUpdateHandler::
#include "trcGenProj/Header/ExternalMediaSourceStateUpdateHandler.cpp.trc.h"
#endif

using namespace ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService;

namespace App {
namespace Core {

ExternalMediaSourceStateUpdateHandler::~ExternalMediaSourceStateUpdateHandler()
{
   ETG_TRACE_COMP(("ExternalMediaSourceStateUpdateHandler::~ExternalMediaSourceStateUpdateHandler"));
   if (_externalMediaSourceConnectionStateHandler != NULL)
   {
      _externalMediaSourceConnectionStateHandler->removeExternalSourceAvailabilityStatusObserver((*this));
   }
}


ExternalMediaSourceStateUpdateHandler::ExternalMediaSourceStateUpdateHandler(): _externalMediaSourceConnectionStateHandler(NULL),
   _externalMediaSourceConnectionStatus(NULL)
{
   ETG_TRACE_COMP(("ExternalMediaSourceStateUpdateHandler::ExternalMediaSourceStateUpdateHandler"));
   _hmiInfoServiceProxyClient = (::HmiInfoServiceProxy::createProxy("hmiinfoservicePort", *this));
   if (_hmiInfoServiceProxyClient.get())
   {
      ETG_TRACE_USR1(("ExternalMediaSourceStateUpdateHandler::ExternalMediaSourceStateUpdateHandler StartupSync _hmiInfoProxyClient"));
      StartupSync::getInstance().registerPropertyRegistrationIF(this, _hmiInfoServiceProxyClient->getPortName());
   }
}


void ExternalMediaSourceStateUpdateHandler::setExternalMediaSourceConnectionStateHandlerInstance(ExternalMediaSourceConnectionStateHandler* _externalMediaSourceConnectionStateHandlerInstance)
{
   if (_externalMediaSourceConnectionStateHandlerInstance != NULL)
   {
      _externalMediaSourceConnectionStateHandler = _externalMediaSourceConnectionStateHandlerInstance;
      _externalMediaSourceConnectionStateHandler->addExternalSourceAvailabilityStatusObserver((*this));
   }
   else
   {
      ETG_TRACE_ERR(("ExternalMediaSourceStateUpdateHandler::_externalMediaSourceConnectionStateHandler is NULL"));
   }
}


void ExternalMediaSourceStateUpdateHandler::setExternalMediaSourceConnectionStatusInstance(ExternalMediaSourceConnectionStatus* _externalMediaSourceConnectionStatusInstance)
{
   if (_externalMediaSourceConnectionStatusInstance != NULL)
   {
      _externalMediaSourceConnectionStatus = _externalMediaSourceConnectionStatusInstance;
   }
   else
   {
      ETG_TRACE_USR4(("ExternalMediaSourceStateUpdateHandler::_externalMediaSourceConnectionStatusInstance is NULL"));
   }
}


void ExternalMediaSourceStateUpdateHandler::onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("ExternalMediaSourceStateUpdateHandler::onAvailable entered"));
   /*if (_hmiInfoServiceProxyClient && _hmiInfoServiceProxyClient == proxy)
   {
      _hmiInfoServiceProxyClient->sendCabinSourcesConnectionStatusRegister(*this);
   }*/
}


void ExternalMediaSourceStateUpdateHandler::onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("ExternalMediaSourceStateUpdateHandler::onUnavailable entered"));

   /*if (_hmiInfoServiceProxyClient && _hmiInfoServiceProxyClient == proxy)
   {
      _hmiInfoServiceProxyClient->sendCabinSourcesConnectionStatusDeregisterAll();
   }*/
}


void ExternalMediaSourceStateUpdateHandler::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("ExternalMediaSourceStateUpdateHandler::registerProperties"));
}


void ExternalMediaSourceStateUpdateHandler::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("ExternalMediaSourceStateUpdateHandler::deregisterProperties"));
}


void ExternalMediaSourceStateUpdateHandler::onSetCabinSourceConnectionStatusError(const ::boost::shared_ptr< HmiInfoServiceProxy >& /*proxy*/,
      const ::boost::shared_ptr< SetCabinSourceConnectionStatusError >& error)
{
   ETG_TRACE_COMP(("ExternalMediaSourceStateUpdateHandler::onSetCabinSourceConnectionStatusError"));
}


void ExternalMediaSourceStateUpdateHandler::onSetCabinSourceConnectionStatusResponse(const ::boost::shared_ptr< HmiInfoServiceProxy >& /*proxy*/,
      const ::boost::shared_ptr< SetCabinSourceConnectionStatusResponse >& error)
{
   ETG_TRACE_COMP(("ExternalMediaSourceStateUpdateHandler::onSetCabinSourceConnectionStatusResponse"));
}


void ExternalMediaSourceStateUpdateHandler::onExternalSourceAvailabilityUpdate()
{
   ETG_TRACE_COMP(("ExternalMediaSourceStateUpdateHandler::onExternalSourceAvailabilityUpdate"));
   std::map<int16, bool> externalSourceStatusMap = _externalMediaSourceConnectionStatus->getExternalSourceConnectionStatusMap();
   std::vector < ::CabinSourceConnectionStatusInfo > cabinSourceConnectionStatusInfo;
   std::map<int16, bool>::iterator itr = externalSourceStatusMap.begin();
   for (; itr != externalSourceStatusMap.end(); ++itr)
   {
      if ((itr->first == SRC_CAMERAPORT1_USB_VIDEO) || /*(itr->first == SRC_CMR1_USB1_VIDEO) ||*/ (itr->first == SRC_CAMERAPORT1_HDMI) || (itr->first == SRC_CAMERAPORT2_HDMI) || (itr->first == SRC_CAMERAPORT3_HDMI)) // Temporarily commented as part of 1606014 - for disabling Router USB
      {
         ::CabinSourceConnectionStatusInfo statusInfo;
         statusInfo.setSourceId(itr->first);
         statusInfo.setStatus(itr->second);
         cabinSourceConnectionStatusInfo.push_back(statusInfo);
      }
   }
   _hmiInfoServiceProxyClient->sendSetCabinSourceConnectionStatusRequest(*this, cabinSourceConnectionStatusInfo);
}


}// namespace Core
}// namespace App
