/**************************************************************************************
* @file         : ExternalMediaSourceConnectionStateHandler.h
* @author       : RBEI/ECG5-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef _EXTERNAL_MEDIASOURCE_CONNECTIONSTATE_HANDLER_H_
#define _EXTERNAL_MEDIASOURCE_CONNECTIONSTATE_HANDLER_H_

#include "Core/ExternalMediaSourceHandler/ExternalMediaSourceHandler.h"
#include "Core/CabinSystemStateHandler/CabinSystemStateHandler.h"
#include "Core/Utils/ExternalMediaSourceConnectionStatus.h"

namespace App {
namespace Core {

class IExternalSourceAvailabilityStatusObserver
{
   public:
      IExternalSourceAvailabilityStatusObserver() {}
      virtual ~IExternalSourceAvailabilityStatusObserver() {}
      virtual void onExternalSourceAvailabilityUpdate() = 0;
};


class ExternalMediaSourceConnectionStateHandler: public ICamportUsbSourceAvailabilityObservor,
   public IhdmiSourceAvailabilityObservor,
   public IRouterSourceAvailabilityObservor,
   public ICabinSystemInfoUpdateObserver
{
   public:
      ExternalMediaSourceConnectionStateHandler();
      virtual ~ExternalMediaSourceConnectionStateHandler();
      void setExternalMediaSourceHandlerInstance(ExternalMediaSourceHandler* _externalMediaSourceHandlerInstance);
      void setCabinSystemStateHandlerInstance(CabinSystemStateHandler* _cabinSystemStateHandlerInstance);
      void setSystemInfoMapInstance(SystemInfoMap* _systemInfoMapInstance);
      void setExternalMediaSourceConnectionStatusInstance(ExternalMediaSourceConnectionStatus* _externalMediaSourceConnectionStatusInstance);
      void addExternalSourceAvailabilityStatusObserver(IExternalSourceAvailabilityStatusObserver& imp);
      void removeExternalSourceAvailabilityStatusObserver(IExternalSourceAvailabilityStatusObserver& imp);
      void initialiseHdmiDevToSysCategoryMap();
      void onCamportUsbSourceAvailabilityUpdate(int usbCamportAvailable);
      void onHdmiSourceAvailabilityUpdate(int srcId, int hdmiavailable);
      void onRouterSourceAvailabilityUpdate(int routerSrcAvailable);
      void onCabinSystemUpdate();
      void updateSourceAvailabilityStatusToMap();
      void notifyExternalSourceAvailabilityStatusListeners();
   private:
      ExternalMediaSourceHandler* _externalMediaSourceHandler;
      CabinSystemStateHandler* _cabinSystemStateHandler;
      SystemInfoMap* _systemInfoMap;
      ExternalMediaSourceConnectionStatus* _externalMediaSourceConnectionStatus;
      ::std::vector< IExternalSourceAvailabilityStatusObserver* > _externalSourceAvailabilityStatusObserver;
      std::map<int, HdmiSrcStatusInfo> _hdmiDeviceInfo;
      int _usbCamportAvailablility;
      int _hdmiAvailability;
      int _routerUSBAvailability;
};


} // namespace Core
} // namespace App


#endif  /* _EXTERNAL_MEDIASOURCE_CONNECTIONSTATE_HANDLER_H_ */
