/**************************************************************************************
* @file         : ExternalMediaSourceActivationFactory.cpp
* @author       : ECV - media
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (C) 2016 Robert Bosch GmbH
*                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include <hmibase/hall_std_if.h>
#include "ExternalMediaSourceActivationFactory.h"
#include "AppHmi_MediaStateMachine.h"
#include "AppHmi_MediaMessages.h"
#include "Core/MediaDefines.h"
#include "Core/ExternalMediaDefines.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_MEDIA_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_MEDIA
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_MEDIA_"
#define ETG_I_FILE_PREFIX                 App::Core::ExternalMediaSourceActivationFactory::
#include "trcGenProj/Header/ExternalMediaSourceActivationFactory.cpp.trc.h"
#endif


namespace App {
namespace Core {

ExternalMediaSourceActivationFactory::ExternalMediaSourceActivationFactory()
{
   ETG_TRACE_USR1(("ExternalMediaSourceActivationFactory Constructor \n"));
}


ExternalMediaSourceActivationFactory::~ExternalMediaSourceActivationFactory()
{
}


/**
 *  ExternalMediaSourceActivationFactory::getExternalActivationSourceHandlerObject - Function to return the IExternalMediaSourceActivationHandler pointer based on the availability of mock
 *  @param [in] listId
 *  @return IExternalMediaSourceActivationHandler
 */
IExternalMediaSourceActivationHandler* ExternalMediaSourceActivationFactory::getExternalActivationSourceHandlerObject(int deviceType)
{
   ETG_TRACE_USR1(("ExternalMediaSourceActivationFactory getExternalActivationSourceHandlerObject \n"));

   IExternalMediaSourceActivationHandler* iExternalSourceActivationHandler = NULL;

   if (deviceType == FI_EN_E8DTY_USB_CAMERAPORT)
   {
      static CamportUSBSourceActivationHandler* camportUSBSourceActivationHandler = new CamportUSBSourceActivationHandler;
      iExternalSourceActivationHandler = camportUSBSourceActivationHandler;
   }
   else if (deviceType == FI_EN_E8DTY_ROUTER_USB)
   {
      static CamportRouterSourceActivationHandler* camportRouterSourceActivationHandler = new CamportRouterSourceActivationHandler;
      iExternalSourceActivationHandler = camportRouterSourceActivationHandler;
   }
   return iExternalSourceActivationHandler;
}


}
}
