/**************************************************************************************
* @file         : CamportUSBSourceActivationHandler.h
* @author       : RBEI/ECH2-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
* 		  			Initial Revision.
**************************************************************************************/

#ifndef _CamportUSBSourceActivationHandler_H_
#define _CamportUSBSourceActivationHandler_H_

#include "Core/PlayableContentInterfaceHandler/PlayableContentInterfaceHandler.h"
#include "Core/ExternalMediaSourceActivation/IExternalMediaSourceActivationHandler.h"
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include <bits/stdc++.h>
#include <map>
#endif

namespace App {
namespace Core {


class CamportUSBSourceActivationHandler
   : public IExternalMediaSourceActivationHandler
{
   public:
      CamportUSBSourceActivationHandler();
      virtual ~CamportUSBSourceActivationHandler();

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      void requestSourceActivation(int regionId);
      void reset();
      void toggleSource();
      void initializeDeviceContentMap();
      void setPlayableMapInstance(PlayableContentMap* _playableContentMapObject);

      int getSourceIDFromActiveContent();
#endif
      int getActiveSourceContentType();
      void updateActivePlayableContentType();

   private:
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      void setLastActiveSourceContentType(int sourceId);
      std::map <int, int> _deviceContentMap;
      PlayableContentMap* _playableContentMap;
#endif

      int _activeContentType ;
      CamportUSBSourceActivationHandler(const CamportUSBSourceActivationHandler& obj);
      CamportUSBSourceActivationHandler& operator= (const CamportUSBSourceActivationHandler& obj);
};


} // namespace Core
} // namespace App


#endif  /* _CamportUSBSourceActivationHandler_H_ */
