/**************************************************************************************
 * @file         : CamportUSBSourceActivationHandler.cpp
 * @author       : RBEI/ECH2-INF4CV_MediaTeam
 * @addtogroup   : AppHmi_media
 * @brief        :
 * @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 * 		  			Initial Revision.
 **************************************************************************************/

#include "CamportUSBSourceActivationHandler.h"
#include "Core/ExternalMediaSourceActivation/IExternalMediaSourceActivationHandler.h"

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "hall_std_if.h"
#include <string>
#include <stdint.h>
#include <map>
#include "Core/SourceSwitch/MediaSourceHandling.h"
#include "Core/ApplicationSwitchClientHandler/ApplicationSwitchClientHandler.h"
#include "AppHmi_MasterBase/AudioInterface/AudioDefines.h"
#include "Core/ExternalMediaDefines.h"
#include "App/datapool/MediaDataPoolConfig.h"

#else
#include "utest/stubs/Apphmi_Media_Types_Common.h"
#endif


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_MEDIA_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_MEDIA
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_MEDIA_"
#define ETG_I_FILE_PREFIX                 App::Core::CamportUSBSourceActivationHandler::
#include "trcGenProj/Header/CamportUSBSourceActivationHandler.cpp.trc.h"
#endif


namespace App {
namespace Core {


CamportUSBSourceActivationHandler::CamportUSBSourceActivationHandler()
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   : _playableContentMap(NULL)
#endif
{
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   ETG_TRACE_USR1(("CamportUSBSourceActivationHandler::CamportUSBSourceActivationHandler constructor is called \n"));
   _activeContentType = EN_DEFAULT_FILE_CONTENT;
   initializeDeviceContentMap();
   setLastActiveSourceContentType(MediaDataPoolConfig::getInstance()->getLastActiveCamportUSBSource());

#endif
}


CamportUSBSourceActivationHandler::~CamportUSBSourceActivationHandler()
{
   ETG_TRACE_USR1(("CamportUSBSourceActivationHandler::CamportUSBSourceActivationHandler  Destructor is called \n"));
}


#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
void CamportUSBSourceActivationHandler::initializeDeviceContentMap()
{
   ETG_TRACE_USR1(("CamportUSBSourceActivationHandler::initializeDeviceContentMap is called"));

   _deviceContentMap.insert(pair<int, int>(EN_AUDIO_FILE_CONTENT, SRC_CAMERAPORT1_USB_AUDIO));
   _deviceContentMap.insert(pair<int, int>(EN_VIDEO_FILE_CONTENT, SRC_CAMERAPORT1_USB_VIDEO));
   _deviceContentMap.insert(pair<int, int>(EN_DEFAULT_FILE_CONTENT, SRC_INVALID));
}


void CamportUSBSourceActivationHandler::requestSourceActivation(int regionId)
{
   ETG_TRACE_USR4(("CamportUSBSourceActivationHandler::requestSourceActivation regionId %d \n", regionId));
   ETG_TRACE_USR4(("CamportUSBSourceActivationHandler::requestSourceActivation _activeContentType %d \n", _activeContentType));

   int srcId  = _deviceContentMap[_activeContentType];

   ETG_TRACE_USR4(("CamportUSBSourceActivationHandler::requestSourceActivation srcId %d \n", srcId));
   MediaDataPoolConfig::getInstance()->setLastActiveCamportUSBSource(srcId);
   if (srcId != SRC_INVALID)
   {
      MediaSourceHandling::getInstance().requestSourceActivation(srcId, -1, regionId);
   }
}


void CamportUSBSourceActivationHandler::setPlayableMapInstance(PlayableContentMap* _playableContentMapObject)
{
   ETG_TRACE_USR1(("CamportUSBSourceActivationHandler::setPlayableMapInstance is entered \n"));
   _playableContentMap = _playableContentMapObject;
}


void CamportUSBSourceActivationHandler::reset()
{
   ETG_TRACE_USR1(("CamportUSBSourceActivationHandler reset \n"));
   _activeContentType = EN_DEFAULT_FILE_CONTENT;
}


#endif


void CamportUSBSourceActivationHandler::updateActivePlayableContentType()
{
   ETG_TRACE_USR1(("CamportUSBSourceActivationHandler::updateActivePlayableContentType \n"));
   bool l_bPlayableAudioContent = false;
   bool l_bPlayableVideoContent = false;
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   l_bPlayableAudioContent = _playableContentMap->getPlayableAudioContent(EnumConst::entSourceType_CMP);
   l_bPlayableVideoContent = _playableContentMap->getPlayableVideoContent(EnumConst::entSourceType_CMP);
   ETG_TRACE_USR4(("CamportUSBSourceActivationHandler::updateActivePlayableContentType _isVideoAvailableContent  %d", l_bPlayableVideoContent));
   ETG_TRACE_USR4(("CamportUSBSourceActivationHandler::updateActivePlayableContentType _isAudioAvailableContent  %d", l_bPlayableAudioContent));
   ETG_TRACE_USR4(("CamportUSBSourceActivationHandler::updateActivePlayableContentType _activeContentType  %d", _activeContentType));

#endif
   if (_activeContentType == EN_DEFAULT_FILE_CONTENT)
   {
      if (l_bPlayableVideoContent == true)
      {
         _activeContentType  = EN_VIDEO_FILE_CONTENT;
      }
      else
      {
         _activeContentType  = EN_AUDIO_FILE_CONTENT;
      }
   }
}


#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
void CamportUSBSourceActivationHandler::toggleSource()
{
   ETG_TRACE_USR1(("CamportUSBSourceActivationHandler toggleSource \n"));
   ETG_TRACE_USR4(("CamportUSBSourceActivationHandler::toggleSource _activeContentType  %d", _activeContentType));

   if (_activeContentType  == EN_AUDIO_FILE_CONTENT)
   {
      _activeContentType  = EN_VIDEO_FILE_CONTENT ;
   }
   else if (_activeContentType  == EN_VIDEO_FILE_CONTENT)
   {
      _activeContentType  = EN_AUDIO_FILE_CONTENT ;
   }
}


void CamportUSBSourceActivationHandler::setLastActiveSourceContentType(int sourceId)
{
   if ((sourceId == SRC_CAMERAPORT1_USB_AUDIO) || (sourceId == SRC_CAMERAPORT1_USB_VIDEO))
   {
      if (sourceId == SRC_CAMERAPORT1_USB_AUDIO)
      {
         _activeContentType = 	EN_AUDIO_FILE_CONTENT;
      }
      else if (sourceId == SRC_CAMERAPORT1_USB_VIDEO)
      {
         _activeContentType = 	EN_VIDEO_FILE_CONTENT;
      }
   }
   else
   {
      _activeContentType = 	EN_DEFAULT_FILE_CONTENT;
   }
   ETG_TRACE_USR4(("CamportUSBSourceActivationHandler::setLastActiveSourceContentType sourceId ,_activeContentType %d ,%d\n", sourceId, _activeContentType));
}


int  CamportUSBSourceActivationHandler::getSourceIDFromActiveContent()
{
   int srcID = SRC_INVALID;
   if (_activeContentType == EN_AUDIO_FILE_CONTENT)
   {
      srcID = SRC_CAMERAPORT1_USB_AUDIO;
   }
   else if (_activeContentType ==	EN_VIDEO_FILE_CONTENT)
   {
      srcID = SRC_CAMERAPORT1_USB_VIDEO;
   }
   else
   {
      srcID = SRC_INVALID;
   }
   return srcID;
   ETG_TRACE_USR4(("CamportUSBSourceActivationHandler::getSourceIDFromActiveContent sourceId ,_activeContentType %d ,%d\n", srcID, _activeContentType));
}


#endif

int CamportUSBSourceActivationHandler::getActiveSourceContentType()
{
   ETG_TRACE_USR4(("CamportUSBSourceActivationHandler::getActiveSourceContentType _activeContentType %d\n", _activeContentType));

   return _activeContentType;
}


}// namespace Core
}// namespace App
