/**************************************************************************************
* @file         : CamportRouterSourceActivationHandler.h
* @author       : RBEI/ECH2-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
* 		  			Initial Revision.
**************************************************************************************/

#ifndef _CamportRouterSourceActivationHandler_H_
#define _CamportRouterSourceActivationHandler_H_

#include "Core/ExternalMediaSourceActivation/IExternalMediaSourceActivationHandler.h"
#include <bits/stdc++.h>
#include <map>
#include "Core/PlayableContentInterfaceHandler/PlayableContentInterfaceHandler.h"

namespace App {
namespace Core {

class CamportRouterSourceActivationHandler
   : public IExternalMediaSourceActivationHandler
{
   public:

      CamportRouterSourceActivationHandler();
      virtual ~CamportRouterSourceActivationHandler();

      void requestSourceActivation(int regionId);
      void reset();
      void toggleSource();
      int getActiveSourceContentType();
      void initializeDeviceContentMap();
      void updateActivePlayableContentType();
      void setPlayableMapInstance(PlayableContentMap* _playableContentMapObject);
      int getSourceIDFromActiveContent();

   private:
      void setLastActiveSourceContentType(int sourceId);
      std::map <int, int> _deviceContentMap;
      int _activeContentType ;

      PlayableContentMap* _playableContentMap;
};


} // namespace Core
} // namespace App


#endif  /* _CamportUSBSourceActivationHandler_H_ */
