/**************************************************************************************
* @file         : ExternalMediaPlaybackHandler.h
* @author       : ECH - voa4kor
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef ExternalMediaPlaybackHandler_H_
#define ExternalMediaPlaybackHandler_H_

#include "AppBase/ServiceAvailableIF.h"
#include "AppHmi_MediaStateMachine.h"
#include "Core/ExternalMediaDefines.h"
#include "Core/MediaDefines.h"
#include "ProjectPluginMsgs.h"
#include "AvdeccPluginConstant.h"
#include "Core/Utils/PlayableContentMap.h"

namespace App {
namespace Core {

//class PluginClientFactory;

class ExternalMediaPlaybackHandler
   : public StartupSync::PropertyRegistrationIF
   , public hmibase::ServiceAvailableIF

{
   public:

      ExternalMediaPlaybackHandler();
      virtual ~ExternalMediaPlaybackHandler();
      static ExternalMediaPlaybackHandler* getInstance();
      //<!--Courier Messages-->
      virtual bool onCourierMessage(const MediaOperationMsgReq& oMsg);

      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      void initializeInstances();
      void initializeExternalSourceRepeatPlaybackActionMap();
      void clearInstance();
      uint8 getPlaybackState();
      uint8 getlastPlaybackState();
      uint8 getShuffleState();
      uint8 getRepeatState();
      tU8 getOperationType();
      void  vUpdatePlayItems(uint8 u8ControlVal, int srcId);
      void  vUpdateRepeatShuffleItems(uint8 u8ControlVal, int srcId);
      void handleExternalSourcePlayTimePluginUpdate(std::string ElapsedplaytimeData, double Elapsedslidervalue, double Totalslidervalue, std::string PlaytimeData, int srcID);
      void handleExternalSourceMetaDataPluginUpdate(int srcID);
      void updateTotalTime(std::string totaltime);
      void updateArtistName(std::string artistName);
      void updateTitleName(std::string titleName);
      void updatePlaybackState();
      void setPlaybackState(uint8 playbackState);
      void updateOperationType();
      void setOperationType(tU8 operationType);
      int updateControlValue(tU8 operationType, int activeSource);
      int getExternalSourceShuffleStatus(int srcId);
      int getExternalSourceRepeatStatus(int srcId);
      bool isRepeatOrShuffleOperation(tU8 operationType);
      void onFolderPlaybackSrcChange(uint16 fileType, uint16 track, std::string path, uint16 listtype, uint8 src, uint16 regionId);
      void setPlayableContentMapInstance(PlayableContentMap* _playableContentMapObject);
      void onPlaybackActionRequest(uint8 operationType, int activeSource);
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_MEDIA_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(MediaOperationMsgReq)
      COURIER_MSG_MAP_END()

      COURIER_BINDING_MAP_BEGIN()

      COURIER_BINDING_MAP_END()

   private:
      static ExternalMediaPlaybackHandler* _externalMediaPlaybackHandler;
      uint8 m_extPlaybackstate;
      uint8 lastPlaybackState;
      uint8 m_extRepeatShufflestate;

      tU8 m_u8ActiveRegion;
      std::map <int, int> _playbackActionMap;
      tU8 u8OperationType;
      std::map <int, int> _repeatshufflePlaybackActionMap;
      std::map <EnumConst::enSubSourceType, externalSourceTypeInfo> _externalSourceTypeMap;

      void initializePlaybackActionMap();
      void initializeExternalSourceTypeMap();
      int getValue(int u8OperationType);
      int getControlValue(tU8 u8OperationType, int activeSource);
      PlayableContentMap* _playableContentMap;
};


}
}


#endif /* ExternalMediaPlaybackHandler_H_ */
