/**************************************************************************************
* @file         : HmiEmpListInterface.h
* @author       : RBEI/ECG5-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef _HMIEMPLISTINTERFACE_H_
#define _HMIEMPLISTINTERFACE_H_

#include "AppHmi_MediaMessages.h"
#include "AppHmi_MediaStateMachine.h"
#include "AppHmi_MediaDatabinding.h"
#include "AvdeccPluginConstant.h"
#include <bits/stdc++.h>
#include <vector>
#include <iterator>
#include <string>
#include <stdint.h>
#include <asf/core/Types.h>
#include "bosch/cm/di/HmiEmpListInterfaceProxy.h"

using namespace ::bosch::cm::di::HmiEmpListInterface;

namespace App {
namespace Core {
/***********************************************************************
Primary Declarations
***********************************************************************/
using namespace ::std;

struct ListContainerStruct
{
   std::string Text1;
   std::string Text2;
   uint16 AbsoluteIndex;
   bool IsSelectedLanguage;
   bosch::cm::di::HmiEmpListInterface::entFileType FileType;
};


struct ListSizeStruct
{
   uint32 Count;
   EnumConst::entListType ListType;
   EnumConst::entSourceType SourceType;
   uint8 Region;
};


class IEmpListSizeObserver
{
   public:
      IEmpListSizeObserver() {}
      virtual ~IEmpListSizeObserver() {}
      virtual void onListSizeUpdate(ListSizeStruct) = 0;
};


class IEmpListContainerObserver
{
   public:
      IEmpListContainerObserver() {}
      virtual ~IEmpListContainerObserver() {}
      virtual void onListContainerUpdate(std::vector<ListContainerStruct>) = 0;
};


class IDBStateObserver
{
   public:
      IDBStateObserver() {}
      virtual ~IDBStateObserver() {}
      virtual void onSig_DBStateSignal(EnumConst::entDownloadState) = 0;
};


class CreateMediaPlayerIndexedListCallbackIF
{
   public:
      virtual ~CreateMediaPlayerIndexedListCallbackIF() {}

      virtual void onCreateMediaPlayerListError() = 0;

      virtual void onCreateMediaPlayerListResult() = 0;
};


class RequestMediaPlayerIndexedListSliceCallbackIF
{
   public:
      virtual ~RequestMediaPlayerIndexedListSliceCallbackIF() {}

      virtual void onRequestMediaPlayerListSliceError() = 0;

      virtual void onRequestMediaPlayerListSliceResult(std::vector<ListContainerStruct> _listSliceContents) = 0;
};


class CreateMediaPlayerIndexedFolderListCallbackIF
{
   public:
      virtual ~CreateMediaPlayerIndexedFolderListCallbackIF() {}

      virtual void onCreateMediaPlayerFolderListError() = 0;

      virtual void onCreateMediaPlayerFolderListResult() = 0;
};


class RequestMediaPlayerIndexedFolderListSliceCallbackIF
{
   public:
      virtual ~RequestMediaPlayerIndexedFolderListSliceCallbackIF() {}

      virtual void onRequestMediaPlayerFolderListSliceError() = 0;

      virtual void onRequestMediaPlayerFolderListSliceResult() = 0;
};


class ReqDBDownloadCallbackIF
{
   public:
      virtual ~ReqDBDownloadCallbackIF() {}

      virtual void onReqDBDownloadError() = 0;

      virtual void onReqDBDownloadResponse() = 0;
};


class SetMediaVideoLanguagesListCallbackIF
{
   public:
      virtual ~SetMediaVideoLanguagesListCallbackIF() {}

      virtual void onMediaVideoLanguagesListError() = 0;

      virtual void onMediaVideoLanguagesListResponse() = 0;
};


class HmiEmpListInterface
{
   public:

      HmiEmpListInterface();
      virtual ~HmiEmpListInterface();
      static HmiEmpListInterface& getInstance();
      void removeInstance();
      void sendReqCreateMediaPlayerListRequest(CreateMediaPlayerIndexedListCallbackIF& ptr, EnumConst::entListType ListType, EnumConst::entSourceType SourceType, uint8 Region,  uint16 absoluteIndex1, uint16 absoluteIndex2);
      void sendReqMediaPlayerListSliceRequest(RequestMediaPlayerIndexedListSliceCallbackIF& ptr, EnumConst::entListType ListType, EnumConst::entSourceType SourceType, uint8 Region, uint16 StartingIndex, uint8 WindowSize, uint16 absoluteIndex1, uint16 absoluteIndex2);
      void sendReqCreateMediaPlayerFolderListRequest(CreateMediaPlayerIndexedFolderListCallbackIF& ptr, EnumConst::entSourceType SourceType, uint8 Region, string folderPath);
      void sendReqMediaPlayerFolderListSliceRequest(RequestMediaPlayerIndexedFolderListSliceCallbackIF& ptr, EnumConst::entSourceType SourceType, uint8 Region, uint16 StartingIndex, uint8 WindowSize, string folderPath);
      void sendReqDBDownloadRequest(ReqDBDownloadCallbackIF& ptr, EnumConst::entSourceType sourceType);
      void sendSetMediaVideoLanguagesListRequest(SetMediaVideoLanguagesListCallbackIF& ptr, uint8 Region, std::vector<uint16> selectedLanguagesId);

      virtual void registerEmpListSizeObserver(IEmpListSizeObserver*);
      virtual void deregisterEmpListSizeObserver(IEmpListSizeObserver*);
      void updateListSizeStructToObservers();

      virtual void registerEmpListContainerObserver(IEmpListContainerObserver*);
      virtual void deregisterEmpListContainerObserver(IEmpListContainerObserver*);
      void updateListContainerStructToObservers(std::vector<ListContainerStruct> _listContents);

      virtual void sendSig_DBStateRegister(IDBStateObserver*);
      virtual void sendSig_DBStateDeregisterAll(IDBStateObserver*);
      void updateDBStateToObservers();

      COURIER_MSG_MAP_BEGIN(0)
      COURIER_MSG_MAP_END()

   private:

      std::vector<IEmpListSizeObserver*> _empListSizeObserver;
      std::vector<IEmpListContainerObserver*> _empListContainerObserver;
      std::vector<IDBStateObserver*> _dbStateObserver;
      ListSizeStruct _listInfo;
      //ListContainerStruct _listContainer;
      std::vector<ListContainerStruct> _listContents;
      EnumConst::entDownloadState _downloadState;
      static HmiEmpListInterface* _theInstance;
      std::map <int, bool> _languageSelectionMap;
      std::string _folderPath;
};


} // end of namespace Core
} // end of namespace App


#endif /* _HMIEMPLISTINTERFACE_H_ */
