/**************************************************************************************
 * @file         : HmiEmpListInterface.cpp
 * @author       : RBEI/ECG5-INF4CV_MediaTeam
 * @addtogroup   : AppHmi_media
 * @brief        :
 * @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 **************************************************************************************/

#include "hall_std_if.h"
#include "HmiEmpListInterface.h"
#include "Core/ExternalMediaDefines.h"
#include <bits/stdc++.h>
#include <vector>
#include <iterator>
#include <string>
#include <stdint.h>


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_MEDIA_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_MEDIA
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_MEDIA_"
#define ETG_I_FILE_PREFIX                 App::Core::ExternalMediaClientHandler::
#include "trcGenProj/Header/HmiEmpListInterface.cpp.trc.h"
#endif


#define LIST_SIZE 30;

namespace App {
namespace Core {


/*static string ListContents[30] = {"Video_1", "Video_2", "Video_3", "Video_4", "Video_5", "Video_6", "Video_7", "Video_8", "Video_9", "Video_10",
                                  "Video_11", "Video_12", "Video_13", "Video_14", "Video_15", "Video_16", "Video_17", "Video_18", "Video_19", "Video_20",
                                  "Video_21", "Video_22", "Video_23", "Video_24", "Video_25", "Video_26", "Video_27", "Video_28", "Video_29", "Video_30"
                                 };*/


static string ListContentsVideo[30] = {"Video_1", "Video_2", "Video_3", "Video_4", "Video_5", "Video_6", "Video_7", "Video_8", "Video_9", "Video_10",
                                       "Video_11", "Video_12", "Video_13", "Video_14", "Video_15", "Video_16", "Video_17", "Video_18", "Video_19", "Video_20",
                                       "Video_21", "Video_22", "Video_23", "Video_24", "Video_25", "Video_26", "Video_27", "Video_28", "Video_29", "Video_30"
                                      };

static string ListContentsSong[30] = {"Song_1", "Song_2", "Song_3", "Song_4", "Song_5", "Song_6", "Song_7", "Song_8", "Song_9", "Song_10",
                                      "Song_11", "Song_12", "Song_13", "Song_14", "Song_15", "Song_16", "Song_17", "Song_18", "Song_19", "Song_20",
                                      "Song_21", "Song_22", "Song_23", "Song_24", "Song_25", "Song_26", "Song_27", "Song_28", "Song_29", "Song_30"
                                     };

static string ListContentsArtist[30] = {"Artist_1", "Artist_2", "Artist_3", "Artist_4", "Artist_5", "Artist_6", "Artist_7", "Artist_8", "Artist_9", "Artist_10",
                                        "Artist_11", "Artist_12", "Artist_13", "Artist_14", "Artist_15", "Artist_16", "Artist_17", "Artist_18", "Artist_19", "Artist_20",
                                        "Artist_21", "Artist_22", "Artist_23", "Artist_24", "Artist_25", "Artist_26", "Artist_27", "Artist_28", "Artist_29", "Artist_30"
                                       };

static string ListContentsAlbum[30] = {"Album_1", "Album_2", "Album_3", "Album_4", "Album_5", "Album_6", "Album_7", "Album_8", "Album_9", "Album_10",
                                       "Album_11", "Album_12", "Album_13", "Album_14", "Album_15", "Album_16", "Album_17", "Album_18", "Album_19", "Album_20",
                                       "Album_21", "Album_22", "Album_23", "Album_24", "Album_25", "Album_26", "Album_27", "Album_28", "Album_29", "Album_30"
                                      };

static string ListContentsGenre[30] = {"Genre_1", "Genre_2", "Genre_3", "Genre_4", "Genre_5", "Genre_6", "Genre_7", "Genre_8", "Genre_9", "Genre_10",
                                       "Genre_11", "Genre_12", "Genre_13", "Genre_14", "Genre_15", "Genre_16", "Genre_17", "Genre_18", "Genre_19", "Genre_20",
                                       "Genre_21", "Genre_22", "Genre_23", "Genre_24", "Genre_25", "Genre_26", "Genre_27", "Genre_28", "Genre_29", "Genre_30"
                                      };

static string ListContentsFolder[30] = {"Folder_1", "Folder_2", "Folder_3", "Folder_4", "Folder_5", "Folder_6", "Folder_7", "Folder_8", "Folder_9", "Folder_10",
                                        "Folder_11", "Folder_12", "Folder_13", "Folder_14", "Folder_15", "Folder_16", "Folder_17", "Folder_18", "Folder_19", "Folder_20",
                                        "Folder_21", "Folder_22", "Folder_23", "Folder_24", "Folder_25", "Folder_26", "Folder_27", "Folder_28", "Folder_29", "Folder_30"
                                       };

static string ListContentsPlaylist[30] = {"Playlist_1", "Playlist_2", "Playlist_3", "Playlist_4", "Playlist_5", "Playlist_6", "Playlist_7", "Playlist_8", "Playlist_9", "Playlist_10",
                                          "Playlist_11", "Playlist_12", "Playlist_13", "Playlist_14", "Playlist_15", "Playlist_16", "Playlist_17", "Playlist_18", "Playlist_19", "Playlist_20",
                                          "Playlist_21", "Playlist_22", "Playlist_23", "Playlist_24", "Playlist_25", "Playlist_26", "Playlist_27", "Playlist_28", "Playlist_29", "Playlist_30"
                                         };

static int ListContentsAbsoluteIndex[30] = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
                                            10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
                                            20, 21, 22, 23, 24, 25, 26, 27, 28, 29
                                           };

static string ListContentsLanguageName[30] = {"Czech", "Danish", "German", "Greek", "English", "Spanish", "French", "Hungarian",
                                              "Norwegian", "Dutch", "Polish", "Portuguese", "Russian", "Swedish", "Turkish",
                                              "Language16", "Language17", "Language18", "Language19", "Language20", "Language21",
                                              "Language22", "Language23", "Language24", "Language25", "Language26", "Language27",
                                              "Language28", "Language29", "Language30",
                                             };
static string ListContentsLanguageISOCode[30] = {"CZE", "DNK", "DEU", "GRC", "ENG", "ESP", "FRA", "HUN",
                                                 "NOR", "NLD", "POL", "PRT", "RUS", "SWE", "TUR",
                                                 "L16", "L17", "L18", "L19", "L20", "L21",
                                                 "L22", "L23", "L24", "L25", "L26", "L27",
                                                 "L28", "L29", "L30",
                                                };
static string ListContentsFolderAndSong[30] = { "Folder_1", "Folder_2", "Folder_3", "Folder_4", "Song_1", "Song_2", "Song_3", "Song_4", "Song_5", "Song_6",                                                "Song_7", "Song_8", "Song_9", "Song_10", "Song_11", "Song_12", "Song_13", "Song_14", "Song_15", "Song_16",                                                "Song_17", "Song_18", "Song_19", "Song_20", "Song_21", "Song_22", "Song_23", "Song_24", "Song_25", "Song_26"};
static bosch::cm::di::HmiEmpListInterface::entFileType ListContentsFolderAndSongFileType[30] = {entFileType__entFileType_Folder, entFileType__entFileType_Folder, entFileType__entFileType_Folder, entFileType__entFileType_Folder,                                                                       entFileType__entFileType_Audio, entFileType__entFileType_Audio, entFileType__entFileType_Audio, entFileType__entFileType_Audio,                                                                       entFileType__entFileType_Audio, entFileType__entFileType_Audio, entFileType__entFileType_Audio, entFileType__entFileType_Audio,                                                                       entFileType__entFileType_Audio, entFileType__entFileType_Audio, entFileType__entFileType_Audio, entFileType__entFileType_Audio,                                                                       entFileType__entFileType_Audio, entFileType__entFileType_Audio, entFileType__entFileType_Audio, entFileType__entFileType_Audio,                                                                       entFileType__entFileType_Audio, entFileType__entFileType_Audio, entFileType__entFileType_Audio, entFileType__entFileType_Audio,                                                                       entFileType__entFileType_Audio, entFileType__entFileType_Audio, entFileType__entFileType_Audio, entFileType__entFileType_Audio,                                                                       entFileType__entFileType_Audio, entFileType__entFileType_Audio};

HmiEmpListInterface* HmiEmpListInterface::_theInstance = 0;

HmiEmpListInterface& HmiEmpListInterface::getInstance()
{
   if (_theInstance == 0)
   {
      _theInstance = new HmiEmpListInterface();
   }

   //assert(_theInstance);
   return *_theInstance;
}


void HmiEmpListInterface::removeInstance()
{
   if (_theInstance)
   {
      delete _theInstance;
      _theInstance = 0;
   }
}


/**
	* Description     : Destructor of class HmiEmpListInterface
	*/
HmiEmpListInterface::~HmiEmpListInterface()
{
   _languageSelectionMap.clear();
}


/**
	* Description     : Constructor of class HmiEmpListInterface
	*/
HmiEmpListInterface::HmiEmpListInterface()
{
   _listInfo.Count = 0;
   _listInfo.ListType = EnumConst::entListType_Invalid;
   _listInfo.SourceType = EnumConst::entSourceType_DEFAULT;
   _listInfo.Region = REGION_INVALID;
   _downloadState = EnumConst::entDownloadState_Default;
   _folderPath = "/";
}


void HmiEmpListInterface::sendReqCreateMediaPlayerListRequest(CreateMediaPlayerIndexedListCallbackIF& ptr, EnumConst::entListType ListType, EnumConst::entSourceType SourceType, uint8 Region, uint16 absoluteIndex1, uint16 absoluteIndex2)
{
   ETG_TRACE_USR4(("HmiEmpListInterface: sendReqCreateMediaPlayerList : ListType: %d ", ListType));
   ETG_TRACE_USR4(("HmiEmpListInterface: sendReqCreateMediaPlayerList : SourceType: %d ", SourceType));
   ETG_TRACE_USR4(("HmiEmpListInterface: sendReqCreateMediaPlayerList : Region: %d ", Region));
   ETG_TRACE_USR4(("HmiEmpListInterface: sendReqCreateMediaPlayerList : absoluteIndex1 absoluteIndex2: %d %d", absoluteIndex1, absoluteIndex2));
   _listInfo.Count = LIST_SIZE;
   _listInfo.ListType = ListType;
   _listInfo.SourceType = SourceType;
   _listInfo.Region = Region;
   ETG_TRACE_USR4(("HmiEmpListInterface: sendReqCreateMediaPlayerList : _listInfo.Count: %d ", _listInfo.Count));
   updateListSizeStructToObservers();
   POST_MSG((COURIER_MESSAGE_NEW(MockCreateListandSliceListResMsg)(EN_LIST_RESPONSE_STATE_CREATELIST)));
}


void HmiEmpListInterface::sendReqCreateMediaPlayerFolderListRequest(CreateMediaPlayerIndexedFolderListCallbackIF& ptr, EnumConst::entSourceType SourceType, uint8 Region, string folderPath)
{
   ETG_TRACE_COMP(("HmiEmpListInterface: sendReqCreateMediaPlayerFolderListRequest : SourceType: %d, Region: %d ", SourceType, Region));
   ETG_TRACE_USR1(("HmiEmpListInterface: sendReqCreateMediaPlayerFolderListRequest : folderPath: %s", folderPath.c_str()));
   _listInfo.Count = LIST_SIZE;
   _listInfo.SourceType = SourceType;
   _listInfo.Region = Region;
   _folderPath = folderPath;
   ETG_TRACE_USR1(("HmiEmpListInterface: sendReqCreateMediaPlayerFolderListRequest : _listInfo.Count: %d ", _listInfo.Count));
   updateListSizeStructToObservers();
   POST_MSG((COURIER_MESSAGE_NEW(MockCreateListandSliceListResMsg)(EN_LIST_RESPONSE_STATE_CREATELIST)));
}


void HmiEmpListInterface::sendReqMediaPlayerListSliceRequest(RequestMediaPlayerIndexedListSliceCallbackIF& ptr, EnumConst::entListType ListType, EnumConst::entSourceType SourceType, uint8 Region, uint16 StartingIndex, uint8 WindowSize, uint16 absoluteIndex1, uint16 absoluteIndex2)
{
   ETG_TRACE_USR4(("HmiEmpListInterface: sendReqMediaPlayerListSlice : ListType: %d ", ListType));
   ETG_TRACE_USR4(("HmiEmpListInterface: sendReqMediaPlayerListSlice : SourceType: %d ", SourceType));
   ETG_TRACE_USR4(("HmiEmpListInterface: sendReqMediaPlayerListSlice : Region: %d ", Region));
   ETG_TRACE_USR4(("HmiEmpListInterface: sendReqMediaPlayerListSlice : StartingIndex: %d ", StartingIndex));
   ETG_TRACE_USR4(("HmiEmpListInterface: sendReqMediaPlayerListSlice : WindowSize: %d ", WindowSize));
   _listContents.clear();
   int list_size = LIST_SIZE;
   ListContainerStruct _listContainer = (struct ListContainerStruct)
   {
      "", "", 0, false, entFileType__entFileType_Video
   };
   for (int currIndex = 0 ; currIndex < list_size ; currIndex++)
   {
      _listContainer.Text1 = "";
      _listContainer.Text2 = "";
      _listContainer.IsSelectedLanguage = false;
      switch (ListType)
      {
         case EnumConst::entListType_Song:
         {
            _listContainer.Text1 = ListContentsSong[currIndex];
            _listContainer.Text2 = ListContentsArtist[currIndex];
            break;
         }
         case EnumConst::entListType_Folder:
         {
            _listContainer.Text1 = ListContentsFolder[currIndex];
            break;
         }
         case EnumConst::entListType_Artist:
         {
            _listContainer.Text1 = ListContentsArtist[currIndex];
            break;
         }
         case EnumConst::entListType_Album:
         {
            _listContainer.Text1 = ListContentsAlbum[currIndex];
            break;
         }
         case EnumConst::entListType_Genre:
         {
            _listContainer.Text1 = ListContentsGenre[currIndex];
            break;
         }
         case EnumConst::entListType_Playlist:
         {
            _listContainer.Text1 = ListContentsPlaylist[currIndex];
            break;
         }
         case EnumConst::entListType_Video:
         {
            if (!_languageSelectionMap.empty())
            {
               if (_languageSelectionMap[currIndex] == true)
               {
                  _listContainer.Text1 = ListContentsVideo[currIndex];
                  _listContainer.Text2 = ListContentsLanguageISOCode[currIndex];
               }
            }
            else
            {
               _listContainer.Text1 = ListContentsVideo[currIndex];
               _listContainer.Text2 = ListContentsLanguageISOCode[currIndex];
            }
            break;
         }
         case EnumConst::entListType_Artist_Album:
         {
            _listContainer.Text1 = ListContentsAlbum[currIndex];
            _listContainer.Text2 = ListContentsArtist[currIndex];
            break;
         }
         case EnumConst::entListType_Artist_Song:
         {
            _listContainer.Text1 = ListContentsSong[currIndex];
            _listContainer.Text2 = ListContentsArtist[currIndex];
            break;
         }
         case EnumConst::entListType_Artist_Album_Song:
         {
            _listContainer.Text1 = ListContentsSong[currIndex];
            _listContainer.Text2 = ListContentsArtist[currIndex];
            break;
         }
         case EnumConst::entListType_Album_Song:
         {
            _listContainer.Text1 = ListContentsSong[currIndex];
            _listContainer.Text2 = ListContentsArtist[currIndex];
            break;
         }
         case EnumConst::entListType_Genre_Album:
         {
            _listContainer.Text1 = ListContentsAlbum[currIndex];
            _listContainer.Text2 = ListContentsArtist[currIndex];
            break;
         }
         case EnumConst::entListType_Genre_Album_Song:
         {
            _listContainer.Text1 = ListContentsSong[currIndex];
            _listContainer.Text2 = ListContentsArtist[currIndex];
            break;
         }
         case EnumConst::entListType_Genre_Song:
         {
            _listContainer.Text1 = ListContentsSong[currIndex];
            _listContainer.Text2 = ListContentsArtist[currIndex];
            break;
         }
         /*case EnumConst::entListType_Video_episode:
         {
            _listContainer.Text1 = ListContentsSong[currIndex];
            break;
         }*/
         case EnumConst::entListType_Playlist_song:
         {
            _listContainer.Text1 = ListContentsSong[currIndex];
            _listContainer.Text2 = ListContentsArtist[currIndex];
            break;
         }
         case EnumConst::entListType_Folder_file:
         {
            _listContainer.Text1 = ListContentsFolder[currIndex];
            break;
         }
         case EnumConst::entListType_Video_Languages:
         {
            _listContainer.Text1 = ListContentsLanguageName[currIndex];
            _listContainer.Text2 = ListContentsLanguageISOCode[currIndex];
            _listContainer.IsSelectedLanguage = _languageSelectionMap[currIndex];
            break;
         }
         default:
         {
            break;
         }
      }
      _listContainer.AbsoluteIndex = ListContentsAbsoluteIndex[currIndex];
      if (!_listContainer.Text1.empty())
      {
         _listContents.push_back(_listContainer);
      }
   }
   ETG_TRACE_USR4(("HmiEmpListInterface: sendReqMediaPlayerListSlice calling updateListContainerStructToObservers"));
   updateListContainerStructToObservers(_listContents);

   POST_MSG((COURIER_MESSAGE_NEW(MockCreateListandSliceListResMsg)(EN_LIST_RESPONSE_STATE_SLICELIST)));
}


void HmiEmpListInterface::sendReqMediaPlayerFolderListSliceRequest(RequestMediaPlayerIndexedFolderListSliceCallbackIF& ptr, EnumConst::entSourceType SourceType, uint8 Region, uint16 StartingIndex, uint8 WindowSize, string folderPath)
{
   ETG_TRACE_COMP(("HmiEmpListInterface: sendReqMediaPlayerFolderListSliceRequest : SourceType: %d, Region: %d, StartingIndex: %d, WindowSize: %d", SourceType, Region, StartingIndex, WindowSize));
   ETG_TRACE_USR1(("HmiEmpListInterface: sendReqMediaPlayerFolderListSliceRequest : folderPath: %s ", folderPath.c_str()));
   _listContents.clear();
   int list_size = LIST_SIZE;
   ListContainerStruct _listContainer = (struct ListContainerStruct)
   {
      "", "", 0, false, entFileType__entFileType_Folder
   };
   int count = std::count(_folderPath.begin(), _folderPath.end(), '/');
   for (int currIndex = 0 ; currIndex < list_size ; currIndex++)
   {
      switch (count)
      {
         case 1:
         {
            _listContainer.Text1 = ListContentsFolder[currIndex];
            _listContainer.FileType = entFileType__entFileType_Folder;
            break;
         }
         case 2:
         case 3:
         {
            _listContainer.Text1 = ListContentsFolderAndSong[currIndex];
            _listContainer.FileType = ListContentsFolderAndSongFileType[currIndex];
            break;
         }
         case 4:
         {
            _listContainer.Text1 = ListContentsSong[currIndex];
            _listContainer.FileType = entFileType__entFileType_Audio;
            break;
         }
         default:
         {
            _listContainer.Text1 = ListContentsSong[currIndex];
            _listContainer.FileType = entFileType__entFileType_Audio;
            break;
         }
      }
      _listContainer.AbsoluteIndex = ListContentsAbsoluteIndex[currIndex];
      if (!_listContainer.Text1.empty())
      {
         _listContents.push_back(_listContainer);
      }
   }
   ETG_TRACE_USR1(("HmiEmpListInterface: sendReqMediaPlayerFolderListSliceRequest calling updateListContainerStructToObservers"));
   updateListContainerStructToObservers(_listContents);
   //ptr.onRequestMediaPlayerListSliceResult(_listContents);
   POST_MSG((COURIER_MESSAGE_NEW(MockCreateListandSliceListResMsg)(EN_LIST_RESPONSE_STATE_SLICELIST)));
}


void HmiEmpListInterface::sendSetMediaVideoLanguagesListRequest(SetMediaVideoLanguagesListCallbackIF& ptr, uint8 Region, std::vector<uint16> selectedLanguagesId)
{
   uint16 iselectedLanguageId = 0;
   _languageSelectionMap.clear();

   for (int index = 0; index < selectedLanguagesId.size(); ++index)
   {
      iselectedLanguageId = (selectedLanguagesId[index]);
      _languageSelectionMap[iselectedLanguageId] = true;
   }
}


void HmiEmpListInterface::sendReqDBDownloadRequest(ReqDBDownloadCallbackIF& ptr, EnumConst::entSourceType sourceType)
{
   ptr.onReqDBDownloadResponse();
   _downloadState = EnumConst::entDownloadState_Downloadsuccess;
   updateDBStateToObservers();
}


void HmiEmpListInterface::registerEmpListSizeObserver(IEmpListSizeObserver* pObserver)
{
   if (pObserver != NULL)
   {
      std::vector<IEmpListSizeObserver*>::iterator itr = ::std::find(_empListSizeObserver.begin(), _empListSizeObserver.end(), pObserver);
      if (itr == _empListSizeObserver.end())
      {
         _empListSizeObserver.push_back(pObserver);
      }
   }
}


void HmiEmpListInterface::deregisterEmpListSizeObserver(IEmpListSizeObserver* pObserver)
{
   std::vector<IEmpListSizeObserver*>::iterator itr = _empListSizeObserver.begin();
   while (itr != _empListSizeObserver.end())
   {
      if (*itr == pObserver)
      {
         _empListSizeObserver.erase(itr);
         break;
      }
      ++itr;
   }
}


void HmiEmpListInterface::updateListSizeStructToObservers()
{
   std::vector<IEmpListSizeObserver*> empListSizeObserver = _empListSizeObserver;
   std::vector<IEmpListSizeObserver*>::iterator itr = empListSizeObserver.begin();

   while (itr != empListSizeObserver.end())
   {
      if (*itr != NULL)
      {
         (*itr)->onListSizeUpdate(_listInfo);
      }
      ++itr;
   }
}


void HmiEmpListInterface::registerEmpListContainerObserver(IEmpListContainerObserver* pObserver)
{
   if (pObserver != NULL)
   {
      std::vector<IEmpListContainerObserver*>::iterator itr = ::std::find(_empListContainerObserver.begin(), _empListContainerObserver.end(), pObserver);
      if (itr == _empListContainerObserver.end())
      {
         _empListContainerObserver.push_back(pObserver);
      }
   }
}


void HmiEmpListInterface::deregisterEmpListContainerObserver(IEmpListContainerObserver* pObserver)
{
   std::vector<IEmpListContainerObserver*>::iterator itr = _empListContainerObserver.begin();
   while (itr != _empListContainerObserver.end())
   {
      if (*itr == pObserver)
      {
         _empListContainerObserver.erase(itr);
         break;
      }
      ++itr;
   }
}


void HmiEmpListInterface::updateListContainerStructToObservers(std::vector<ListContainerStruct> _listContents)
{
   ETG_TRACE_USR4(("HmiEmpListInterface: updateListContainerStructToObservers "));
   std::vector<IEmpListContainerObserver*> empListContainerObserver = _empListContainerObserver;
   std::vector<IEmpListContainerObserver*>::iterator itr = empListContainerObserver.begin();

   while (itr != empListContainerObserver.end())
   {
      if (*itr != NULL)
      {
         ETG_TRACE_USR4(("HmiEmpListInterface: updateListContainerStructToObservers : loop"));
         (*itr)->onListContainerUpdate(_listContents);
      }
      ++itr;
   }
}


void HmiEmpListInterface::sendSig_DBStateRegister(IDBStateObserver* pObserver)
{
   if (pObserver != NULL)
   {
      std::vector<IDBStateObserver*>::iterator itr = ::std::find(_dbStateObserver.begin(), _dbStateObserver.end(), pObserver);
      if (itr == _dbStateObserver.end())
      {
         _dbStateObserver.push_back(pObserver);
      }
   }
}


void HmiEmpListInterface::sendSig_DBStateDeregisterAll(IDBStateObserver* pObserver)
{
   std::vector<IDBStateObserver*>::iterator itr = _dbStateObserver.begin();
   while (itr != _dbStateObserver.end())
   {
      if (*itr == pObserver)
      {
         _dbStateObserver.erase(itr);
         break;
      }
      ++itr;
   }
}


void HmiEmpListInterface::updateDBStateToObservers()
{
   std::vector<IDBStateObserver*> dbStateObserver = _dbStateObserver;
   std::vector<IDBStateObserver*>::iterator itr = dbStateObserver.begin();

   while (itr != dbStateObserver.end())
   {
      if (*itr != NULL)
      {
         (*itr)->onSig_DBStateSignal(_downloadState);
      }
      ++itr;
   }
}


} // end of namespace Core
} // end of namespace App
