/**************************************************************************************
* @file         : MediaSourceHandling.h
* @author       : RBEI/ECG5-INF4CV_MediaTeam
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#ifndef CabinSystemStateHandler_h
#define CabinSystemStateHandler_h

#include "AppHmi_MediaStateMachine.h"
#include "AppHmi_MediaMessages.h"
#include "AppBase/ServiceAvailableIF.h"
#include "AppHmi_MediaDatabinding.h"
#include "bosch/cm/ai/hmi/hmiinfoservice/HmiInfoServiceProxy.h"
#include "Core/Utils/SystemInfoMap.h"


using namespace ::asf::core;
using namespace ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService;
#include "asf/core/Types.h"

namespace App {
namespace Core {

class IpnmGroup10StatusObservor;
class ICabinSystemInfoUpdateObserver;

class CabinSystemStateHandler
   : public ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
   , public CabinsSystemsInfoCallbackIF
{
   public:
      CabinSystemStateHandler();
      virtual ~CabinSystemStateHandler();

      virtual void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange);
      virtual void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange);

      virtual void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      virtual void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      virtual void onCabinsSystemsInfoError(const ::boost::shared_ptr< HmiInfoServiceProxy >& /*proxy*/,
                                            const ::boost::shared_ptr< CabinsSystemsInfoError >& error);

      virtual void onCabinsSystemsInfoUpdate(const ::boost::shared_ptr< HmiInfoServiceProxy >& /*proxy*/,
                                             const ::boost::shared_ptr< CabinsSystemsInfoUpdate >& update);

      void setSystemInfoMapInstance(SystemInfoMap* _systemInfoMapInstance);
      void addCabinSystemInfoUpdateObserver(ICabinSystemInfoUpdateObserver& imp);
      void removeCabinSystemInfoUpdateObserver(ICabinSystemInfoUpdateObserver& imp);
      void notifyCabinSystemInfoUpdateListeners();

   private:

      ::boost::shared_ptr< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::HmiInfoServiceProxy> _hmiInfoServiceProxyClient;
      SystemInfoMap* _systemInfoMap;
      std::map <int, int> _externalSourceMap;
      std::vector<ICabinSystemInfoUpdateObserver* > _cabinSystemInfoUpdateListener ;

      void initialiseCameraportSourceMap();
      bool isValidSubSystemDisconnectState(uint8 systemStatus);
      void onCabinSystemInfoUpdate();
};


class ICabinSystemInfoUpdateObserver
{
   public:
      ICabinSystemInfoUpdateObserver() {}
      virtual ~ICabinSystemInfoUpdateObserver() {}
      virtual void onCabinSystemUpdate() = 0;
};


}
}


#endif
