/**************************************************************************************
* @file         : CabinSourceRestoration.h
* @author       : ECG2 - vta5kor
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef CabinSourceRestoration_H_
#define CabinSourceRestoration_H_
#include "mplay_MediaPlayer_FI.h"
#include "mplay_MediaPlayer_FIProxy.h"
#include "bosch/cm/ai/hmi/masteraudioservice/AudioSourceChangeProxy.h"
#include "bosch/cm/ai/hmi/hmiinfoservice/HmiInfoServiceProxy.h"
#include "AppBase/ServiceAvailableIF.h"
#include "Core/ExternalMediaSourceHandler/ExternalMediaSourceHandler.h"
#include "AvdeccPluginConstant.h"
#include"Core/ExternalMediaSourceActivation/IExternalMediaSourceActivationHandler.h"
#include "Core/ExternalMediaSourceActivation/ExternalMediaSourceActivationFactory.h"
#include "Core/Utils/PlayableContentMap.h"
#include "Core/Utils/SystemInfoMap.h"
#include "asf/core/Timer.h"
#include "Core/ListHandling/ExternalMediaListDBManager/ExternalMediaListDBManager.h"
#include "Core/ExternalMediaClientHandler/ExternalMediaClientHandler.h"


#define MASTERAUDIOSERVICE_INTERFACE ::bosch::cm::ai::hmi::masteraudioservice

using namespace ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService;
class StartupSync;


namespace App {
namespace Core {

class CabinSourceRestoration
   : public hmibase::ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
   , public ::mplay_MediaPlayer_FI::MediaPlayerDeviceConnectionsCallbackIF
   , public MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::SourceAvailabilityChangedCallbackIF
   , public CabinsSourceRestorationInfoCallbackIF
   , public ::App::Core::IRouterSourceAvailabilityObservor
   , public ::App::Core::ICamportUsbSourceAvailabilityObservor
   , public MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::ActiveSourceListCallbackIF
   , public ::App::Core::IExternalDBDownloadUpdateObservor
   , public RegionsMapOutStatusInfoCallbackIF
   , public ::App::Core::IhdmiSourceAvailabilityObservor
   , public RestoreAVSourceCallbackIF


{
   public:

      CabinSourceRestoration();
      virtual ~CabinSourceRestoration();

      virtual void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      virtual void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      // ServiceAvailableIF implementation
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      virtual void onCabinsSourceRestorationInfoError(const ::boost::shared_ptr< HmiInfoServiceProxy >& /*proxy*/,
            const ::boost::shared_ptr< CabinsSourceRestorationInfoError >& error);

      virtual void onCabinsSourceRestorationInfoUpdate(const ::boost::shared_ptr< HmiInfoServiceProxy >& /*proxy*/,
            const ::boost::shared_ptr< CabinsSourceRestorationInfoUpdate >& update);

      virtual void onMediaPlayerDeviceConnectionsStatus(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& /*proxy*/,
            const boost::shared_ptr< ::mplay_MediaPlayer_FI::MediaPlayerDeviceConnectionsStatus >& status);/*status*/
      virtual void onMediaPlayerDeviceConnectionsError(const ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy >& /*proxy*/,
            const boost::shared_ptr< ::mplay_MediaPlayer_FI::MediaPlayerDeviceConnectionsError >& error);

      virtual void onSourceAvailabilityChangedSignal(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
            const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::SourceAvailabilityChangedSignal >& signal);

      virtual void onSourceAvailabilityChangedError(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
            const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::SourceAvailabilityChangedError >& error);

      virtual void onActiveSourceListError(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& proxy,
                                           const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::ActiveSourceListError >& error);

      virtual void onActiveSourceListUpdate(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& proxy,
                                            const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::ActiveSourceListUpdate >& signal);
      virtual void onRegionsMapOutStatusInfoError(const ::boost::shared_ptr< HmiInfoServiceProxy >& /*proxy*/,
            const ::boost::shared_ptr< RegionsMapOutStatusInfoError >& error);

      virtual void onRegionsMapOutStatusInfoUpdate(const ::boost::shared_ptr< HmiInfoServiceProxy >& /*proxy*/,
            const ::boost::shared_ptr< RegionsMapOutStatusInfoUpdate >& update);

      virtual void onRestoreAVSourceError(const ::boost::shared_ptr< HmiInfoServiceProxy >& /*proxy*/,
                                          const ::boost::shared_ptr< RestoreAVSourceError >& error);

      virtual void onRestoreAVSourceSignal(const ::boost::shared_ptr< HmiInfoServiceProxy >& /*proxy*/,
                                           const ::boost::shared_ptr< RestoreAVSourceSignal >& signal);

      void onExternalDBDownloadUpdate(uint8 downloadState, EnumConst::entSourceType sourceType);
      void onRouterSourceAvailabilityUpdate(int iRouterAvailability);
      void onCamportUsbSourceAvailabilityUpdate(int iUSBCamportAvailability);
      void onHdmiSourceAvailabilityUpdate(int srcId, int hdmiavailable);
      void setExternalMediaSourceHandlerInstance(ExternalMediaSourceHandler* _externalMediaSourceHandlerInstance);
      void setExternalMediaClientHandlerInstance(ExternalMediaClientHandler* _externalMediaClientHandlerInstance);
      void setPlayableContentMapInstance(PlayableContentMap* _playableContentMapInstance);
      void setSystemInfoMapInstance(SystemInfoMap* _systemInfoMapInstance);
      void updateMediaGadgetIndex(uint32 restorationStatus);
      void setExternalMediaListDBManagerInstance(ExternalMediaListDBManager* _externalMediaListDBManagerInstance);

   private:
      ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy > _audioSourceChangeProxy;
      ::boost::shared_ptr< ::mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy > _mediaPlayerProxy; // reference for media player proxy
      ::boost::shared_ptr< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::HmiInfoServiceProxy> _hmiInfoServiceProxyClient;

      CabinSourceRestoration& operator= (const CabinSourceRestoration& obj);
      CabinSourceRestoration(const CabinSourceRestoration& obj);
      uint32 _cabinRegion ;
      bool _isSourceConnected ;
      ::MPlay_fi_types::T_MPlayDeviceInfo _oDeviceInfo;
      int _sourceId;
      uint8 _subSrcId;
      uint32 _restorationStatus;
      std::map <int, bool> _mediaSourceAvailabilityMap;
      ExternalMediaSourceHandler* _externalMediaSourceHandler;
      PlayableContentMap* _playableContentMap;
      SystemInfoMap* _systemInfoMap;
      bool isSourceConnected(std::vector<SourceInfoHolder>SourcesInfo);
      uint8 getSystemCategory(int16 sinkId);
      bool isInternalSourceConnected(uint8 subSrcId);
      void requestExternalSourceActivation(int srcId, int cabinId);
      void restoreSourceinCabin(int srciID, uint32 cabinId, int16 sinkId, uint32 restorationStatus, bool sourceConnectionState);
      void initializeMediaSourceMap();
      bool _isSourceRestored;
      ExternalMediaListDBManager* _externalMediaListDBManager;
      ExternalMediaClientHandler* _externalMediaClientHandler;
      int16 _sinkId;
};


}
}


#endif /* BTCLIENTHANDLER_H_ */
