/**************************************************************************************
* @file         : BTCLIENTHANDLER.h
* @author       : ECG2 - vta5kor
* @addtogroup   : AppHmi_media
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef BTCLIENTHANDLER_H_
#define BTCLIENTHANDLER_H_


#include "MOST_BTSet_FI.h"
#include "MOST_BTSet_FIProxy.h"
#include "AppBase/ServiceAvailableIF.h"
#include "DataModel/HMIModelComponent.h"


class StartupSync;

namespace App {
namespace Core {

class BTClientHandler
   : public hmibase::ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
   , public ::MOST_BTSet_FI::DeviceListExtendedCallbackIF
   , public ::MOST_BTSet_FI::BluetoothOnOffCallbackIF
{
   public:

      BTClientHandler();
      virtual ~BTClientHandler();

      virtual void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy,
                                      const asf::core::ServiceStateChange& stateChange);
      virtual void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy,
                                        const asf::core::ServiceStateChange& stateChange);

      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      virtual void onDeviceListExtendedError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& /*proxy*/,
                                             const ::boost::shared_ptr< ::MOST_BTSet_FI::DeviceListExtendedError >& /*error*/);
      virtual void onDeviceListExtendedStatus(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& /*proxy*/,
                                              const ::boost::shared_ptr< ::MOST_BTSet_FI::DeviceListExtendedStatus >& status);

      virtual void onBluetoothOnOffError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& /*proxy*/,
                                         const ::boost::shared_ptr< ::MOST_BTSet_FI::BluetoothOnOffError >& /*error*/);

      virtual void onBluetoothOnOffStatus(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& /*proxy*/,
                                          const ::boost::shared_ptr< ::MOST_BTSet_FI::BluetoothOnOffStatus >& status);
      /*COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_MEDIA_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_DUMMY_CASE(0)
      COURIER_MSG_MAP_DELEGATE_START()
      COURIER_MSG_MAP_DELEGATE_END()*/

      bool getConnectedDeviceStatus(std::string deviceName);
      bool getConnectedDeviceAVPStatus(std::string deviceName);
      bool isAnyBTDeviceConnected();
      bool isAVPProfileActiveInConnectedBTDevice();
      static BTClientHandler* getInstance()
      {
         if (NULL == _btClientHandler)
         {
            _btClientHandler = new BTClientHandler();
         }

         return _btClientHandler;
      }
      bool isBluetoothSettingsOn();
   private:

      void onDeviceListExtendedStatusResult(::most_BTSet_fi_types_Extended::T_BTSetDeviceListExtendedResult&);

      ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy > _btSettingProxy;
      ::most_BTSet_fi_types_Extended::T_BTSetDeviceListExtendedResult btDeviceList;
      std::string btDeviceName;
      bool m_isBluetoothOn;
      static BTClientHandler* _btClientHandler;
};


}
}


#endif /* BTCLIENTHANDLER_H_ */
