/* ***************************************************************************************
* FILE:          CGIAppPopupTable.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CGIAppPopupTable.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"
#include "CgiExtensions/PopupConfig.h"

#include "CGIAppViewController_VolumeMain.h"
#include "ProjectBaseTypes.h"

POPUP_TABLE_BEGIN() // popup ID, modality, priority, presentation time, min. presentation time, validity period, close on superseded, close on app leave, surface ID, path in asset
POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 10, 5000, 2000, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_VOLUME_MAIN),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 10, 0, 0, 0, false, false, SURFACEID_CONTROLPANEL_POPUP_SURFACE, CGIAppViewController_VOLUME_CENTER_POPUP),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 5, 0, 0, 0, true, false, SURFACEID_CONTROLPANEL_POPUP_SURFACE, CGIAppViewController_HomeScreen_1_POPUPEXP_DEV, false),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 12, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Wait_Scene),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 5, 0, 0, 0, false, false, SURFACEID_CONTROLPANEL_POPUP_SURFACE, CGIAppViewController_HomeScreen_CabinAPopup_Expand, false),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 5, 0, 0, 0, false, false, SURFACEID_CONTROLPANEL_POPUP_SURFACE, CGIAppViewController_HomeScreen_CabinBPopup_Expand, false),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 12, 0, 0, 0, true, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_SRC_Cockpit, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 12, 0, 0, 0, true, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_SRC_Cabin, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 3, 0, 0, 0, true, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_HourLogicMode, false),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 12, 0, 0, 0, true, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_SystemStartUpMode, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 12, 0, 0, 0, true, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_SystemStartUpCompletion, true),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 10, 0, 0, 0, false, false, SURFACEID_CONTROLPANEL_POPUP_SURFACE, CGIAppViewController_VOLUME_CENTER_POPUP_CABINA),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 1, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_SystemHeat_PopUp),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 11, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMAAVDECCDisconnected, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 12, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMGAVDECCDisconnected, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 12, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMGAVDECCDisconnected_Mix, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 12, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMPAVDECCDisconnected, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 11, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMANANOMsgDisconnected, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 12, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMGNANOMsgDisconnected, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 12, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMGNANOMsgDisconnected_Mix, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 12, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMPNANOMsgDisconnected, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 12, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMCNANOMsgDisconnected, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 12, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMCAVDECCDisconnected, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 1, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_KDSCompletion_Status, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 12, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMGVoltageOverWarningError, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 12, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMGVoltageOverWarningError_Mix, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 12, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMGVoltageUnderWarningError, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 12, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMGVoltageUnderWarningError_Mix, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 12, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMPVoltageOverWarningError, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 12, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMPVoltageUnderWarningError, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 11, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMCVoltageOverWarningError, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 11, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMCVoltageUnderWarningError, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 3, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMAVoltageOverWarningError, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 3, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMAVoltageUnderWarningError, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 12, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMGThermalOverWarningError, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 12, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMGThermalOverWarningError_Mix, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 12, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMGThermalUnderWarningError, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 12, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMGThermalUnderWarningError_Mix, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 12, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMPThermalOverWarningError, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 12, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMPThermalUnderWarningError, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 11, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMCThermalOverWarningError, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 11, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMCThermalUnderWarningError, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 3, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMAThermalOverWarningError, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 11, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMAThermalUnderWarningError, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 10, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMASystemConnected, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 12, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMRAVDECCDisconnected, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 12, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMRNANOMsgDisconnected, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 12, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMRThermalOverWarningError, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 12, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMRThermalUnderWarningError, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 12, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMRVoltageOverWarningError, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 12, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_CMRVoltageUnderWarningError, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 12, 0, 0, 0, true, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_MIC2CenterActivePopup, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 12, 0, 0, 0, true, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_MIC2CenterDeactivePopup, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 12, 0, 0, 0, true, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_MIC3CenterActivePopup, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System, 12, 0, 0, 0, true, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Pfo_MIC3CenterDeactivePopup, true)
//POPUP_TABLE_ENTRY(ScreenBroker::Modality::System, 10, 0, 0, 0, false, false, SURFACEID_CENTER_POPUP_SURFACE_MASTER, CGIAppViewController_Rvc_Scene)
                  POPUP_TABLE_END()
