/**
 * @file         : CabinVideoMixInfoDPIF.h
 * @author       : INF4CV -  AppHmi_Master Team
 * @brief        : CabinActivityInfoDPIF is provides datapool interface for cabin video mix
 * @copyright    : (C) 2021 Robert Bosch GmbH
 *                 (C) 2021 Robert Bosch Engineering and Business Solutions Limited
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */

#ifndef CABIN_VIDEOMIX_INFO_DP_IF_H
#define CABIN_VIDEOMIX_INFO_DP_IF_H

#include "asf/core/Types.h"

class CabinVideoMixInfoHolder
{
   public:
      /**
       *  Member Functions Declaration
       */
      CabinVideoMixInfoHolder()
      {
         clear();
      }

      virtual ~CabinVideoMixInfoHolder()
      {
         clear();
      }

      CabinVideoMixInfoHolder(const CabinVideoMixInfoHolder& obj)
      {
         clear();
         *this = obj;
      }

      CabinVideoMixInfoHolder& operator = (const CabinVideoMixInfoHolder& obj)
      {
         if (this != &obj)
         {
            _cabinId = obj.getCabinId();
            _videoMixIndex = obj.getVideoMixIndex();
         }
         return *this;
      }

      void clear()
      {
         _cabinId = 3/* REGION_INVALID */;
         _videoMixIndex = 0/*CABIN_VIDEO_MIX_INDEX_NONE*/;
      }

      void setCabinId(const uint32 cabinId)
      {
         _cabinId = cabinId;
      }

      uint32 getCabinId() const
      {
         return _cabinId;
      }

      void setVideoMixIndex(const uint8 videoMixIndex)
      {
         _videoMixIndex = videoMixIndex;
      }

      uint8 getVideoMixIndex() const
      {
         return _videoMixIndex;
      }
   private:
      /**
       *  Member Variables Declaration
       */
      uint32 _cabinId;
      uint8 _videoMixIndex;
};


#endif
