/**
 * @file         : DataModelErrorPopup.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : DataModelErrorPopup is to handle the data model implementation of
 *                 Error popups.
 * @copyright    : (c) 2020-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef DATA_MODEL_ERROR_PPOPUP_H
#define DATA_MODEL_ERROR_PPOPUP_H


#include <Core/HmiState/HmiStateHandlerInterface.h>
#include <Core/RegionHandling/RegionHandlingInterface.h>


/**
 *  Classes Forward Declaration
 */
namespace App {
namespace Core {

class CabinConnectionUtility;
} //namespace Core
} //namespace App

class IHmiInfoServiceServerComponent;


/**
 *  Classes Declaration
 */

namespace App {
namespace datamodel {


class DataModelErrorPopup : public ::App::Core::IHmiStateListenerCB
   , public ::App::Core::ICMAStatusListenerCB
   , public ::App::Core::IAVDECCCMAStatusListenerCB
   , public ::App::Core::IAVDECCCMPStatusListenerCB
   , public ::App::Core::IAVDECCCMGStatusListenerCB
   , public ::App::Core::IAVDECCCMRStatusListenerCB
   , public ::App::Core::INANOMsgCMAStatusListenerCB
   , public ::App::Core::INANOMsgCMPStatusListenerCB
   , public ::App::Core::INANOMsgCMGStatusListenerCB
   , public ::App::Core::INANOMsgCMRStatusListenerCB
   , public ::App::Core::IVoltageCMCStatusListenerCB
   , public ::App::Core::IVoltageCMAStatusListenerCB
   , public ::App::Core::IVoltageCMPStatusListenerCB
   , public ::App::Core::IVoltageCMGStatusListenerCB
   , public ::App::Core::IVoltageCMRStatusListenerCB
   , public ::App::Core::IThermalCMCStatusListenerCB
   , public ::App::Core::IThermalCMAStatusListenerCB
   , public ::App::Core::IThermalCMPStatusListenerCB
   , public ::App::Core::IThermalCMGStatusListenerCB
   , public ::App::Core::IThermalCMRStatusListenerCB
   , public ::App::Core::IHourLogicExpireStatusCB
{
   public:
      /**
       *  Member Functions Declaration
       */
      DataModelErrorPopup();
      virtual ~DataModelErrorPopup();
      void onHmiStateUpdate(const uint8 hmiState);
      void onCMAStatusUpdate(const ::App::Core::SystemStatusInfo& info);
      void onAVDECCCMAStatusUpdate(const ::App::Core::SystemStatusInfo& info);
      void onAVDECCCMPStatusUpdate(const ::App::Core::SystemStatusInfo& info);
      void onAVDECCCMGStatusUpdate(const ::App::Core::SystemStatusInfo& info);
      void onAVDECCCMRStatusUpdate(const ::App::Core::SystemStatusInfo& info);
      void onNANOMsgCMAStatusUpdate(const ::App::Core::SystemStatusInfo& info);
      void onNANOMsgCMPStatusUpdate(const ::App::Core::SystemStatusInfo& info);
      void onNANOMsgCMGStatusUpdate(const ::App::Core::SystemStatusInfo& info);
      void onNANOMsgCMRStatusUpdate(const ::App::Core::SystemStatusInfo& info);
      void onVoltageCMCStatusUpdate(const ::App::Core::SystemStatusInfo& info);
      void onVoltageCMAStatusUpdate(const ::App::Core::SystemStatusInfo& info);
      void onVoltageCMGStatusUpdate(const ::App::Core::SystemStatusInfo& info);
      void onVoltageCMPStatusUpdate(const ::App::Core::SystemStatusInfo& info);
      void onVoltageCMRStatusUpdate(const ::App::Core::SystemStatusInfo& info);
      void onThermalCMCStatusUpdate(const ::App::Core::SystemStatusInfo& info);
      void onThermalCMAStatusUpdate(const ::App::Core::SystemStatusInfo& info);
      void onThermalCMGStatusUpdate(const ::App::Core::SystemStatusInfo& info);
      void onThermalCMPStatusUpdate(const ::App::Core::SystemStatusInfo& info);
      void onThermalCMRStatusUpdate(const ::App::Core::SystemStatusInfo& info);
      void onHourLogicExpireStatusUpdate(const bool hourLogicExpireStatus);

      inline void setRegionHandling(::App::Core::IRegionHandling& imp)
      {
         _regionHandling = (&imp);
      }

      inline void setHMIStateHandler(::App::Core::IHmiStateHandler& imp)
      {
         _hmiStateHandler = (&imp);
      }

      inline void setHmiInfoServiceServerComponent(IHmiInfoServiceServerComponent& imp)
      {
         _hmiInfoServiceServerComponent = (&imp);
      }

      inline void setCabinConnectionUtility(::App::Core::CabinConnectionUtility& imp)
      {
         _cabinConnectionUtility = (&imp);
      }

      inline void initialize()
      {
         if (NULL != _regionHandling)
         {
            _regionHandling->addCMAStatusListener((*this));
            _regionHandling->addAVDECCCMAStatusListener((*this));
            _regionHandling->addAVDECCCMPStatusListener((*this));
            _regionHandling->addAVDECCCMGStatusListener((*this));
            _regionHandling->addAVDECCCMRStatusListener((*this));
            _regionHandling->addNANOMsgCMAStatusListener((*this));
            _regionHandling->addNANOMsgCMPStatusListener((*this));
            _regionHandling->addNANOMsgCMGStatusListener((*this));
            _regionHandling->addNANOMsgCMRStatusListener((*this));
            _regionHandling->addVoltageCMCStatusListener((*this));
            _regionHandling->addVoltageCMAStatusListener((*this));
            _regionHandling->addVoltageCMPStatusListener((*this));
            _regionHandling->addVoltageCMGStatusListener((*this));
            _regionHandling->addVoltageCMRStatusListener((*this));
            _regionHandling->addThermalCMCStatusListener((*this));
            _regionHandling->addThermalCMAStatusListener((*this));
            _regionHandling->addThermalCMPStatusListener((*this));
            _regionHandling->addThermalCMGStatusListener((*this));
            _regionHandling->addThermalCMRStatusListener((*this));
         }
         if (NULL != _hmiStateHandler)
         {
            _hmiStateHandler->addHmiStateListener(this);
            _hmiStateHandler->addHourLogicExpireStatusListener(this);
         }
      }

      inline void finalize()
      {
         if (NULL != _regionHandling)
         {
            _regionHandling->removeCMAStatusListener((*this));
            _regionHandling->removeAVDECCCMAStatusListener((*this));
            _regionHandling->removeAVDECCCMPStatusListener((*this));
            _regionHandling->removeAVDECCCMGStatusListener((*this));
            _regionHandling->removeAVDECCCMRStatusListener((*this));
            _regionHandling->removeNANOMsgCMAStatusListener((*this));
            _regionHandling->removeNANOMsgCMPStatusListener((*this));
            _regionHandling->removeNANOMsgCMGStatusListener((*this));
            _regionHandling->removeNANOMsgCMRStatusListener((*this));
            _regionHandling->removeVoltageCMCStatusListener((*this));
            _regionHandling->removeVoltageCMAStatusListener((*this));
            _regionHandling->removeVoltageCMPStatusListener((*this));
            _regionHandling->removeVoltageCMGStatusListener((*this));
            _regionHandling->removeVoltageCMRStatusListener((*this));
            _regionHandling->removeThermalCMCStatusListener((*this));
            _regionHandling->removeThermalCMAStatusListener((*this));
            _regionHandling->removeThermalCMPStatusListener((*this));
            _regionHandling->removeThermalCMGStatusListener((*this));
            _regionHandling->removeThermalCMRStatusListener((*this));
         }
         if (NULL != _hmiStateHandler)
         {
            _hmiStateHandler->removeHmiStateListener(this);
            _hmiStateHandler->removeHourLogicExpireStatusListener(this);
         }
      }

   private:
      /**
       *  Member Functions Declaration
       */
      DataModelErrorPopup(const DataModelErrorPopup& obj);
      DataModelErrorPopup& operator= (const DataModelErrorPopup& obj);

      bool isGlassA2Configured(const uint32 regionId);
      int16 getSinkIdForSystemId(const uint8 systemId) const;
      uint8 getVideoMixIndex(const uint32 regionId) const;
      void evalAndUpdateHourLogicStatus();
      void evalAndUpdateVoltageStatus();
      /**
       *  Member Variables Declaration
       */
      ::App::Core::IRegionHandling* _regionHandling;
      ::App::Core::IHmiStateHandler* _hmiStateHandler;
      ::App::Core::CabinConnectionUtility* _cabinConnectionUtility;
      IHmiInfoServiceServerComponent* _hmiInfoServiceServerComponent;
};


} //namespace datamodel
} //namespace App


#endif /* DATA_MODEL_CONTROL_PANEL_H */
