/**
 * @file <VehicleSrvClient.h>
 * @author <ECG> <INF4CV>
 * @copyright (c) 2018-2019 Robert Bosch Car Multimedia GmbH
 * @addtogroup <AppHmi_Master>
 */

#ifndef VEHICLE_SRV_CLIENT_H
#define VEHICLE_SRV_CLIENT_H

#include "VEHICLE_MAIN_FIProxy.h"
#include "vehicle_main_fi_types.h"
#include "AppBase/ServiceAvailableIF.h"
#include "App/Core/VehicleSrvClient/IVehicleSrvClientInterface.h"
namespace App {
namespace Core {

class VehicleSrvClient :
   public hmibase::ServiceAvailableIF
   , public ::VEHICLE_MAIN_FI::VINCallbackIF
   , public ::VEHICLE_MAIN_FI::VolumeCommandCallbackIF
   , public ::VEHICLE_MAIN_FI::MediaStatusVolumeCallbackIF
   , public ::VEHICLE_MAIN_FI::CabinMediaStatusVolumeCallbackIF
   , public ::VEHICLE_MAIN_FI::MediaStatusMuteStatusCallbackIF
   , public ::VEHICLE_MAIN_FI::CabinMediaStatusMuteStatusCallbackIF
   , public ::VEHICLE_MAIN_FI::CabinMediaStatusAudioSourceCallbackIF
   , public ::VEHICLE_MAIN_FI::MediaStatusAudioSourceCallbackIF
   , public ::VEHICLE_MAIN_FI::CabinMediaVolumeCommandCallbackIF
   , public ::VEHICLE_MAIN_FI::DeviceStatusNaviAvailCallbackIF
   , public ::VEHICLE_MAIN_FI::DeviceStatusNavDataCallbackIF
   , public ::VEHICLE_MAIN_FI::RadioPwrCmdCallbackIF
   , public IVehicleSrvClient
{
   public:
      static VehicleSrvClient* poGetInstance();
      virtual ~VehicleSrvClient();
      void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      virtual void onVINError(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< VEHICLE_MAIN_FI::VINError >& error);
      virtual void onVINStatus(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< VEHICLE_MAIN_FI::VINStatus >& status);
      virtual void onMediaStatusVolumeError(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/,
                                            const ::boost::shared_ptr< VEHICLE_MAIN_FI::MediaStatusVolumeError >& /*error*/) {};
      virtual void onMediaStatusVolumeResult(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/,
                                             const ::boost::shared_ptr< VEHICLE_MAIN_FI::MediaStatusVolumeResult >& /*result*/) {};
      virtual void onCabinMediaStatusVolumeError(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/,
            const ::boost::shared_ptr< VEHICLE_MAIN_FI::CabinMediaStatusVolumeError >& /*error*/) {};
      virtual void onCabinMediaStatusVolumeResult(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/,
            const ::boost::shared_ptr< VEHICLE_MAIN_FI::CabinMediaStatusVolumeResult >& /*result*/) {};
      virtual void onMediaStatusMuteStatusError(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/,
            const ::boost::shared_ptr< VEHICLE_MAIN_FI::MediaStatusMuteStatusError >& /*error*/) {};
      virtual void onMediaStatusMuteStatusResult(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/,
            const ::boost::shared_ptr< VEHICLE_MAIN_FI::MediaStatusMuteStatusResult >& /*result*/) {};
      virtual void onCabinMediaStatusMuteStatusError(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/,
            const ::boost::shared_ptr< VEHICLE_MAIN_FI::CabinMediaStatusMuteStatusError >& /*error*/) {};
      virtual void onCabinMediaStatusMuteStatusResult(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/,
            const ::boost::shared_ptr< VEHICLE_MAIN_FI::CabinMediaStatusMuteStatusResult >& /*result*/) {};
      virtual void onCabinMediaStatusAudioSourceError(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/,
            const ::boost::shared_ptr< VEHICLE_MAIN_FI::CabinMediaStatusAudioSourceError >& error) {};
      virtual void onCabinMediaStatusAudioSourceResult(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/,
            const ::boost::shared_ptr< VEHICLE_MAIN_FI::CabinMediaStatusAudioSourceResult >& result) {};
      virtual void onMediaStatusAudioSourceError(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/,
            const ::boost::shared_ptr< VEHICLE_MAIN_FI::MediaStatusAudioSourceError >& error) {};
      virtual void onMediaStatusAudioSourceResult(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/,
            const ::boost::shared_ptr< VEHICLE_MAIN_FI::MediaStatusAudioSourceResult >& result) {};
      virtual void onVolumeCommandError(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< VEHICLE_MAIN_FI::VolumeCommandError >& error);
      virtual void onVolumeCommandStatus(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< VEHICLE_MAIN_FI::VolumeCommandStatus >& status);
      virtual void onCabinMediaVolumeCommandError(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< VEHICLE_MAIN_FI::CabinMediaVolumeCommandError >& error);
      virtual void onCabinMediaVolumeCommandStatus(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< VEHICLE_MAIN_FI::CabinMediaVolumeCommandStatus >& status);
      virtual void onDeviceStatusNavDataError(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/,
                                              const ::boost::shared_ptr< VEHICLE_MAIN_FI::DeviceStatusNavDataError >& /*error*/) {};

      virtual void onDeviceStatusNavDataResult(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/,
            const ::boost::shared_ptr< VEHICLE_MAIN_FI::DeviceStatusNavDataResult >& /*result*/) {};
      virtual void onDeviceStatusNaviAvailError(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/,
            const ::boost::shared_ptr< VEHICLE_MAIN_FI::DeviceStatusNaviAvailError >& /*error*/) {};

      virtual void onDeviceStatusNaviAvailResult(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/,
            const ::boost::shared_ptr< VEHICLE_MAIN_FI::DeviceStatusNaviAvailResult >& /*result*/) {};

      virtual void onRadioPwrCmdError(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/, const ::boost::shared_ptr< VEHICLE_MAIN_FI::RadioPwrCmdError >& /*error*/);
      virtual void onRadioPwrCmdStatus(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/, const ::boost::shared_ptr< VEHICLE_MAIN_FI::RadioPwrCmdStatus >& status);

      bool fetchGetVINValue(uint32& value) const;
      void sendCabinAMuteUpdateToCluster(const uint8 state);
      void sendCockpitMuteUpdateToCluster(const uint8 state);
      void sendCabinAVolumeUpdateToCluster(const uint8 volume);
      void sendCockpitVolumeUpdateToCluster(const uint8 volume);
      void sendCabinAActiveAudioSourceToCluster(const uint32 sourceIndex);
      void sendCockpitActiveAudioSourceToCluster(const uint32 sourceIndex);
      inline void addVolumeCommandListener(IVolumeCommandValueUpdateListenerCB& imp)
      {
         ::std::vector< IVolumeCommandValueUpdateListenerCB* >::const_iterator itr = ::std::find(_VolumeCommandValue.begin(), _VolumeCommandValue.end(), (&imp));
         if (itr == _VolumeCommandValue.end())
         {
            _VolumeCommandValue.push_back((&imp));
         }
      }
      inline void removeVolumeCommandListener(IVolumeCommandValueUpdateListenerCB& imp)
      {
         ::std::vector< IVolumeCommandValueUpdateListenerCB* >::iterator itr = ::std::find(_VolumeCommandValue.begin(), _VolumeCommandValue.end(), (&imp));
         if (itr != _VolumeCommandValue.end())
         {
            (void)_VolumeCommandValue.erase(itr);
         }
      }

      inline void addRadioPwrCommandListener(IRadioPwrCommandValueUpdateListenerCB& imp)
      {
         ::std::vector< IRadioPwrCommandValueUpdateListenerCB* >::const_iterator itr = ::std::find(_radioPwrCmdValue.begin(), _radioPwrCmdValue.end(), (&imp));
         if (itr == _radioPwrCmdValue.end())
         {
            _radioPwrCmdValue.push_back((&imp));
         }
      }
      inline void removeRadioPwrCommandListener(IRadioPwrCommandValueUpdateListenerCB& imp)
      {
         ::std::vector< IRadioPwrCommandValueUpdateListenerCB* >::iterator itr = ::std::find(_radioPwrCmdValue.begin(), _radioPwrCmdValue.end(), (&imp));
         if (itr != _radioPwrCmdValue.end())
         {
            (void)_radioPwrCmdValue.erase(itr);
         }
      }
   private:
      VehicleSrvClient();
      VehicleSrvClient(const VehicleSrvClient& obj);
      VehicleSrvClient& operator = (const VehicleSrvClient& obj);
      void sendDeviceStatusNavDataToCluster();
      static VehicleSrvClient* _VehicleSrvClient;
      ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy> _vehicleProxy;
      ::std::vector< IVolumeCommandValueUpdateListenerCB* > _VolumeCommandValue;
      ::std::vector< IRadioPwrCommandValueUpdateListenerCB* > _radioPwrCmdValue;
};


}
}


#endif
