/**************************************************************************************
* @file         : <VehicleSrvClient.cpp>
* @author       : <ECG> <INF4CV>
* @addtogroup   : <AppHmi_System>
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "hall_std_if.h"
#include "VehicleSrvClient.h"
#include "AppHmi_MasterMessages.h"
#include <Core/VariantHandling/VariantHandling.h>


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_MASTER_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_MASTER
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_Master_"
#define ETG_I_FILE_PREFIX                 App::Core::VehicleSrvClient::
#include "trcGenProj/Header/VehicleSrvClient.cpp.trc.h"
#endif

/**
 *  Defines Declaration
 */

#define NAVDATA_AVAIL 1
#define NAVDATA_ERROR 2
#define NAVDATA_UNAVAIL 0


using namespace ::vehicle_main_fi_types;
using namespace ::VEHICLE_MAIN_FI;

namespace App {
namespace Core {

VehicleSrvClient* VehicleSrvClient::_VehicleSrvClient = NULL;
VehicleSrvClient::VehicleSrvClient(): _vehicleProxy(::VEHICLE_MAIN_FIProxy::createProxy("vehicleMainFiPort", *this))
{
   ETG_TRACE_USR4(("VehicleSrvClient Constructor is called"));
   if (NULL != _vehicleProxy.get())
   {
      ETG_TRACE_USR4(("VehicleSrvClient Constructor after creating proxy"));
   }
}


VehicleSrvClient::~VehicleSrvClient()
{
   ETG_TRACE_USR4(("VehicleSrvClient destructor is called"));
   _VolumeCommandValue.clear();
}


VehicleSrvClient* VehicleSrvClient::poGetInstance()
{
   if (_VehicleSrvClient == NULL)
   {
      _VehicleSrvClient = new VehicleSrvClient();
   }
   return _VehicleSrvClient;
}


void VehicleSrvClient::onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("VehicleSrvClient onAvailable is called"));
   if ((proxy == _vehicleProxy) && (NULL != _vehicleProxy.get()))
   {
      _vehicleProxy->sendVINUpReg(*this);
      _vehicleProxy->sendVolumeCommandUpReg(*this);
      _vehicleProxy->sendCabinMediaVolumeCommandUpReg(*this);
      _vehicleProxy->sendRadioPwrCmdUpReg(*this);
      sendDeviceStatusNavDataToCluster();
   }
}


void VehicleSrvClient::onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("VehicleSrvClient onUnavailable is called"));
   if ((proxy == _vehicleProxy) && (NULL != _vehicleProxy.get()))
   {
      _vehicleProxy->sendVINRelUpRegAll();
      _vehicleProxy->sendVolumeCommandRelUpRegAll();
      _vehicleProxy->sendCabinMediaVolumeCommandRelUpRegAll();
      _vehicleProxy->sendRadioPwrCmdRelUpRegAll();
   }
}


void VehicleSrvClient::onVINError(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< VEHICLE_MAIN_FI::VINError >& error)
{
   ETG_TRACE_USR4(("VehicleDataClientHandler::onVINError()"));
}


void VehicleSrvClient::onVINStatus(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< VEHICLE_MAIN_FI::VINStatus >& status)
{
   ETG_TRACE_USR4(("VehicleDataHandler::onVINStatus %x", status->getVINValue()));
   UpdateVINStatus* oMsg = COURIER_MESSAGE_NEW(UpdateVINStatus)();
   if (NULL != oMsg)
   {
      oMsg->Post();
   }
}


void VehicleSrvClient::onVolumeCommandError(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< VEHICLE_MAIN_FI::VolumeCommandError >& error)
{
   ETG_TRACE_USR4(("VehicleDataClientHandler::onVolumeCommandError()"));
}


void VehicleSrvClient::onVolumeCommandStatus(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< VEHICLE_MAIN_FI::VolumeCommandStatus >& status)
{
   ETG_TRACE_USR4(("VehicleDataHandler::onVolumeCommandStatus %x", status->getVolumeCommandValue()));
   uint8 volumeCmndValue = status->getVolumeCommandValue();
   switch (volumeCmndValue)
   {
      case 1: //Demute
      case 2: //Mute
      case 3: //Volume Increase
      case 4: //Volume Decrease
      {
         for (::std::vector< IVolumeCommandValueUpdateListenerCB* >::const_iterator itr = _VolumeCommandValue.begin(); (itr != _VolumeCommandValue.end()); ++itr)
         {
            if (NULL != (*itr))
            {
               (*itr)->onVolumeCommandValueUpdate(REGION_COCKPIT, volumeCmndValue);
            }
         }
      }
      break;

      default:
         break;
   }
}


void VehicleSrvClient::onCabinMediaVolumeCommandError(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< VEHICLE_MAIN_FI::CabinMediaVolumeCommandError >& error)
{
   ETG_TRACE_USR4(("VehicleDataClientHandler::onCabinMediaVolumeCommandError()"));
}


void VehicleSrvClient::onCabinMediaVolumeCommandStatus(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< VEHICLE_MAIN_FI::CabinMediaVolumeCommandStatus >& status)
{
   ETG_TRACE_USR4(("VehicleDataHandler::onCabinMediaVolumeCommandStatus %x", status->getCabinMediaVolumeCommandValue()));
   uint8 cabinVolumeCmndValue = status->getCabinMediaVolumeCommandValue();
   switch (cabinVolumeCmndValue)
   {
      case 1: //Demute
      case 2: //Mute
      case 3: //Volume Increase
      case 4: //Volume Decrease
      {
         for (::std::vector< IVolumeCommandValueUpdateListenerCB* >::const_iterator itr = _VolumeCommandValue.begin(); (itr != _VolumeCommandValue.end()); ++itr)
         {
            if (NULL != (*itr))
            {
               (*itr)->onVolumeCommandValueUpdate((fnGetLastActiveCabinRegionId()), cabinVolumeCmndValue);
            }
         }
      }
      break;

      default:
         break;
   }
}


void VehicleSrvClient::onRadioPwrCmdError(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/, const ::boost::shared_ptr< VEHICLE_MAIN_FI::RadioPwrCmdError >& /*error*/)
{
   ETG_TRACE_USR4(("VehicleDataClientHandler::onRadioPwrCmdError()"));
}


void VehicleSrvClient::onRadioPwrCmdStatus(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/, const ::boost::shared_ptr< VEHICLE_MAIN_FI::RadioPwrCmdStatus >& status)
{
   ETG_TRACE_USR4(("VehicleDataHandler::onRadioPwrCmdStatus %x", status->getRadioPwrCmdValue()));
   uint8 radioPwrCmdValue = status->getRadioPwrCmdValue();
   switch (radioPwrCmdValue)
   {
      case RADIOPWR_ON: //RadioON
      case RADIOPWR_OFF: //RadioOff
      {
         for (::std::vector< IRadioPwrCommandValueUpdateListenerCB* >::const_iterator itr = _radioPwrCmdValue.begin(); (itr != _radioPwrCmdValue.end()); ++itr)
         {
            if (NULL != (*itr))
            {
               (*itr)->onRadioCommandValueUpdate(radioPwrCmdValue);
            }
         }
      }
      break;

      default:
         break;
   }
}


void VehicleSrvClient::sendCabinAMuteUpdateToCluster(const uint8 state)
{
   if (NULL != _vehicleProxy.get())
   {
      ETG_TRACE_USR4(("VehicleSrvClient: sendCabinAMuteUpdateToCluster: ->: State: %d", state));
      _vehicleProxy->sendCabinMediaStatusMuteStatusStart(*this, state);
   }
}


void VehicleSrvClient::sendCockpitMuteUpdateToCluster(const uint8 state)
{
   if (NULL != _vehicleProxy.get())
   {
      ETG_TRACE_USR4(("VehicleSrvClient: sendCockpitMuteUpdateToCluster: ->: State: %d", state));
      _vehicleProxy->sendMediaStatusMuteStatusStart(*this, state);
   }
}


void VehicleSrvClient::sendCabinAVolumeUpdateToCluster(const uint8 volume)
{
   if (NULL != _vehicleProxy.get())
   {
      ETG_TRACE_USR4(("VehicleSrvClient: sendCabinAVolumeUpdateToCluster: ->: Volume: %d", volume));
      _vehicleProxy->sendCabinMediaStatusVolumeStart(*this, volume);
   }
}


void VehicleSrvClient::sendCockpitVolumeUpdateToCluster(const uint8 volume)
{
   if (NULL != _vehicleProxy.get())
   {
      ETG_TRACE_USR4(("VehicleSrvClient: sendCockpitVolumeUpdateToCluster: ->: Volume: %d", volume));
      _vehicleProxy->sendMediaStatusVolumeStart(*this, volume);
   }
}


void VehicleSrvClient::sendCabinAActiveAudioSourceToCluster(const uint32 sourceIndex)
{
   if (NULL != _vehicleProxy.get())
   {
      ETG_TRACE_USR4(("VehicleSrvClient: sendCabinAActiveAudioSourceToCluster: ->: SourceIndex: %d", sourceIndex));
      _vehicleProxy->sendCabinMediaStatusAudioSourceStart(*this, sourceIndex);
   }
}


void VehicleSrvClient::sendCockpitActiveAudioSourceToCluster(const uint32 sourceIndex)
{
   if (NULL != _vehicleProxy.get())
   {
      ETG_TRACE_USR4(("VehicleSrvClient: sendCockpitActiveAudioSourceToCluster: ->: SourceIndex: %d", sourceIndex));
      _vehicleProxy->sendMediaStatusAudioSourceStart(*this, sourceIndex);
   }
}


bool VehicleSrvClient::fetchGetVINValue(uint32& value) const
{
   bool isFetched = false;
   if ((NULL != _vehicleProxy.get()) && (_vehicleProxy->hasVIN()))
   {
      value     = _vehicleProxy->getVIN().getVINValue();
      isFetched = true;
   }
   return isFetched;
}


void VehicleSrvClient::sendDeviceStatusNavDataToCluster()
{
   if (NULL != _vehicleProxy.get())
   {
      uint8 variantType = fnGetVariantType();
      uint8 navData = NAVDATA_ERROR;
      if (variantType == VARIANT_TYPE_NAVI)
      {
         navData = NAVDATA_AVAIL;
      }
      else if (variantType == VARIANT_TYPE_NONNAVI)
      {
         navData = NAVDATA_UNAVAIL;
      }
      else
      {
      }
      ETG_TRACE_USR4(("VehicleSrvClient: sendDeviceStatusNavDataToCluster: ->: navData: %d", navData));
      _vehicleProxy->sendDeviceStatusNavDataStart(*this, navData);
      _vehicleProxy->sendDeviceStatusNaviAvailStart(*this, navData);
   }
}


}
}
