/**
 * @file         : IVehicleSrvClientInterface.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : IVehicleSrvClientInterface is to handle volume update for  datamodelSound
 *                 feature interface implementation.
 * @copyright    : (C) 2016 Robert Bosch GmbH
 *                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef VEHICLE_SRV_CLIENT_INTERFACE_H
#define VEHICLE_SRV_CLIENT_INTERFACE_H

#define RADIOPWR_ON   1
#define RADIOPWR_OFF  2
/**
 *  Classes Declaration
 */

namespace App {
namespace Core {

class IVolumeCommandValueUpdateListenerCB;
class IRadioPwrCommandValueUpdateListenerCB;

class IVehicleSrvClient
{
   public:
      /**
       *  Member Functions Declaration
       */
      IVehicleSrvClient() {}
      virtual ~IVehicleSrvClient() {}
      bool fetchGetVINValue(uint32& value) const;
      virtual void sendCabinAMuteUpdateToCluster(const uint8 state) = 0;
      virtual void sendCockpitMuteUpdateToCluster(const uint8 state) = 0;
      virtual void sendCabinAVolumeUpdateToCluster(const uint8 volume) = 0;
      virtual void sendCockpitVolumeUpdateToCluster(const uint8 volume) = 0;
      virtual void sendCabinAActiveAudioSourceToCluster(const uint32 sourceIndex) = 0;
      virtual void sendCockpitActiveAudioSourceToCluster(const uint32 sourceIndex) = 0;
      virtual void addVolumeCommandListener(IVolumeCommandValueUpdateListenerCB& imp) = 0;
      virtual void removeVolumeCommandListener(IVolumeCommandValueUpdateListenerCB& imp) = 0;
      virtual void addRadioPwrCommandListener(IRadioPwrCommandValueUpdateListenerCB& imp) = 0;
      virtual void removeRadioPwrCommandListener(IRadioPwrCommandValueUpdateListenerCB& imp) = 0;
};


class IVolumeCommandValueUpdateListenerCB
{
   public:
      /**
       *  Member Functions Declaration
       */
      IVolumeCommandValueUpdateListenerCB() {}
      virtual ~IVolumeCommandValueUpdateListenerCB() {}
      virtual void onVolumeCommandValueUpdate(uint32 regionID, const uint8 VolumeCmndValue) = 0;
};


class IRadioPwrCommandValueUpdateListenerCB
{
   public:
      /**
       *  Member Functions Declaration
       */
      IRadioPwrCommandValueUpdateListenerCB() {}
      virtual ~IRadioPwrCommandValueUpdateListenerCB() {}
      virtual void onRadioCommandValueUpdate(const uint8 RadioCmndValue) = 0;
};


} //namespace Core
} //namespace App


#endif /* VEHICLE_SRV_CLIENT_INTERFACE_H */
