/**
 * @file         : VariantHandling.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : VariantHandling is to handle the variant information
 * @copyright    : (c) 2020-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef VARIANTHANDLING_HEADER
#define VARIANTHANDLING_HEADER

#include "AppHmi_MasterStateMachine.h"

#ifndef WIN32 /* Linux / Other OS env except Windows */
#include "pthread.h"
#endif
#include <asf/core/Types.h>

#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
#include "AppHmi_MasterTypes_Mock.h"
#include "ProjectBaseTypes_Mock.h"
#endif

/**
 *  Classes Declaration
 */


namespace App {
namespace Core {

class VariantHandling_Test;

class VariantHandling
{
   public:
      /**
       *  Member Functions Declaration
       */
      VariantHandling();
      virtual ~VariantHandling();
      uint16 getVariantId();
      uint8 getVariantType();
      bool isSXMAvailable();
      bool isBTAvailable();
      bool isCPAvailable();
      bool isAndroidAutoAvailable();
      bool isMySpinAvailable();
      bool isSPIAvailable();
      bool isHDMIAvailable();
      bool isCamportUSBAvailable();
      bool isEURRegion();
      uint16 getPresentationTimeAVSource();
      uint16 getPresentationTimeAnalogueCamera();
      uint16 getPresentationTimeIPCamera();
      uint16 getPresentationTimeAmplifier_USBVideo();
      uint16 getPresentationTimeAmplifier_HDMI();
      uint16 getPresentationTimeAmplifier_Audio();
      uint16 getPresentationTimeGlass_DRM();
      uint16 getPresentationTimeAmp_DRM();
   private:
      /**
       *  Member Functions Declaration
       */
      VariantHandling(const VariantHandling& obj);
      VariantHandling& operator= (const VariantHandling& obj);
      void readKDSVariantId();
      void readKDSVariantType();
      void readKDSSXMAvailability();
      void readKDSBTAvailability();
      void readKDSCPAvailability();
      void readKDSAndroidAutoAvailability();
      void readKDSMySpinAvailability();
      void readKDSHDMIAvailability();
      void readKDSCMPUSBAvailability();
      void readKDSRegionType();
      void readKDSPresentationTimeAVSource();
      void readKDSPresentationTimeAnalogueCamera();
      void readKDSPresentationTimeIPCamera();
      void readKDSPresentationTimeAmplifier_USBVideo();
      void readKDSPresentationTimeAmplifier_HDMI();
      void readKDSPresentationTimeAmplifier_Audio();
      void readKDSPresentationTimeAmp_DRM();
      void readKDSPresentationTimeGlass_DRM();
      /**
       *  Member Variables Declaration
       */
      uint16 _variantId;
      uint8 _variantType;
      uint8 _sxmAvailable;
      uint8 _btAvailable;
      uint8 _cpAvailable;
      uint8 _aaAvailable;
      uint8 _mySpinAvailable;
      uint8 _isHDMIAvailable;
      uint8 _isCamportUSBAvailable;
      enRegionType _regionType;
      uint16 _glassAVSourcePresTime;
      uint16 _glassAnalogueCameraPresTime;
      uint16 _glassIPCameraPresTime;
      uint16 _amplifierUSBVideoSourcePresTime;
      uint16 _amplifierHDMIPresTime;
      uint16 _amplifierAudioPresTime;
      uint16 _ampDRMPresTime;
      uint16 _glassDRMPresTime;


#ifndef WIN32 /* Linux / Other OS env except Windows */
      static pthread_mutex_t _safeLock;
#endif
#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
      friend class App::Core::VariantHandling_Test;
#endif
};


} //namespace Core
} //namespace App


#endif /* VARIANTHANDLING_HEADER */
