/**************************************************************************************
 * @file         : UserInterfaceHandler.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : UserInterfaceHandler is to manage keys registration
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 **************************************************************************************/


#ifndef USERINTERFACEHANDLER_H_
#define USERINTERFACEHANDLER_H_


#include "App/Core/KeyRouter/IKeyRouterUserInterface.h"


namespace hmi {
namespace apphmi_master {

class IHmiAppCtrlAppInfoInterface;
} //namespace apphmi_master
} //namespace hmi


namespace App {
namespace Core {


class UserInterfaceHandler: public ::keyRouter::IKeyRouterUserInterface
{
   public:
      /**
       *  Member Functions Declaration
       */
      UserInterfaceHandler();
      virtual ~UserInterfaceHandler();
      int getHardKeyRegisteredApp(const ::keyRouterTypes::KeyInfo< uint32 >& hardKeyInfo);
      int getEncoderRegisteredApp(const ::keyRouterTypes::KeyInfo< int32 >& encoderInfo);
      int getRegisterdAppForPhnKeys(int pid, int userData);

      inline void setHmiAppCtrlAppInfoImpl(::hmi::apphmi_master::IHmiAppCtrlAppInfoInterface* imp)
      {
         _appInfoImpl = imp;
      }

   private:
      /**
       *  Member Variables Declaration
       */
      ::hmi::apphmi_master::IHmiAppCtrlAppInfoInterface* _appInfoImpl;
};


} //namespace App
} //namespace Core


#endif /* USERINTERFACEHANDLER_H_ */
