/**
 * @file         : SystemMonitorHandlerInterfaces.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : SystemMonitorHandlerInterfaces is to handle interfaces implemeteation of
 *                 SystemMonitorHandler feature
 * @copyright    : (c) 2020-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef SYSTEM_MONITOR_HANDLER_INTERFACES_H
#define SYSTEM_MONITOR_HANDLER_INTERFACES_H


#include <asf/core/Types.h>
#include <boost/shared_ptr.hpp>


/**
 *  Classes Forward Declaration
 */

class ISoundControllerPrj;
class IResourceControllerPrj;
class IConnectionControllerPrj;


namespace App {
namespace Core {


class IRegionHandling;
class IVehicleSrvClient;
class IMediaClientHandler;
} //namespace Core
} //namespace App


/**
 *  Classes Declaration
 */

namespace App {
namespace Core {


class ISystemMonitorHandler
{
   public:
      /**
       *  Member Functions Declaration
       */
      ISystemMonitorHandler() {}
      virtual ~ISystemMonitorHandler() {}
      virtual void finalize() = 0;
      virtual void initialize() = 0;
      virtual void setRegionHandling(::App::Core::IRegionHandling& imp) = 0;
      virtual void setVehicleSrvClient(::App::Core::IVehicleSrvClient& imp) = 0;
      virtual void setMediaClientHandler(::App::Core::IMediaClientHandler& imp) = 0;
      virtual void setSoundController(const ::boost::shared_ptr< ISoundControllerPrj >& imp) = 0;
      virtual void setResourceController(const ::boost::shared_ptr< IResourceControllerPrj >& imp) = 0;
      virtual void setConnectionController(const ::boost::shared_ptr< IConnectionControllerPrj >& imp) = 0;
};


} //namespace Core
} //namespace App


#endif /* SYSTEM_MONITOR_HANDLER_INTERFACES_H */
