/**
 * @file         : RootContextHandlerInterface.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : RootContextHandlerInterface is to handle the RootContextHandler
 *                 feature interface implementation.
 * @copyright    : (c) 2019-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef ROOT_CONTEXT_HANDLER_INTERFACE_H
#define ROOT_CONTEXT_HANDLER_INTERFACE_H


#include <asf/core/Types.h>


/**
 *  Classes Declaration
 */

namespace App {
namespace Core {


/**
 * IRootContextHandler is used to
 *  - Provide interface impl between Users and RootContextHandler.
 */
class IRootContextHandler
{
   public:
      /**
       *  Member Functions Declaration
       */
      IRootContextHandler() {}
      virtual ~IRootContextHandler() {}
      virtual bool isContextValidToClearStack(const uint32 contextId) const = 0;
};


} //namespace Core
} //namespace App


#endif /* ROOT_CONTEXT_HANDLER_INTERFACE_H */
