/**
 * @file         : RootContextHandler.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : RootContextHandler is to handle the root context (activity) information
 *                 i.e. Context (activity) which denotes beginning of the transition
 *                 always (EX: HomeScreen).
 * @copyright    : (c) 2019-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef ROOT_CONTEXT_HANDLER_H
#define ROOT_CONTEXT_HANDLER_H


#include "RootContextHandlerInterface.h"
#include <vector>


/**
 *  Classes Declaration
 */

namespace App {
namespace Core {


/**
 * RootContextHandler is used to
 *  - Handle the root context (activity) information
 *      i.e. Context (activity) which denotes beginning
 *      of the transition always (EX: HomeScreen).
 */
class RootContextHandler : public IRootContextHandler
{
   public:
      /**
       *  Member Functions Declaration
       */
      RootContextHandler();
      virtual ~RootContextHandler();
      bool isContextValidToClearStack(const uint32 contextId) const;

   private:
      /**
       *  Member Typedefs Declaration
       */
      typedef ::std::vector< uint32 > RootContextsInfo;
      /**
       *  Member Functions Declaration
       */
      RootContextHandler(const RootContextHandler& obj);
      RootContextHandler& operator= (const RootContextHandler& obj);
      void initRootContextsInfo();

      inline void clear()
      {
         _rootContextsInfo.clear();
      }
      /**
       *  Member Variables Declaration
       */
      RootContextsInfo _rootContextsInfo;
};


} //namespace Core
} //namespace App


#endif /* ROOT_CONTEXT_HANDLER_H */
