/**
 * @file         : RegionHandlingConstants.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : RegionHandlingConstants is to handle the RegionHandling
 *                 feature constants implementation
 * @copyright    : (c) 2019-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef REGION_HANDLING_CONSTANTS_H
#define REGION_HANDLING_CONSTANTS_H


#include <asf/core/Types.h>
#include <boost/tuple/tuple.hpp>


/**
 *  Classes Forward Declaration
 */

namespace App {
namespace Core {


class SystemInfo;
class SinkStaticInfo;
class SystemRegionInfo;
} //namespace Core
} //namespace App


/**
 *  Typedefs Declaration
 */

namespace App {
namespace Core {


typedef ::std::vector< int16 > SinkIdsInfo;
typedef ::std::vector< uint8 > SystemsIdInfo;
typedef ::std::vector< uint8 > SystemsGroupInfo;
typedef ::std::vector< int16 > SourceIdsInfo;
typedef ::std::vector< uint32 > RegionsIdInfo;
typedef ::std::vector< SystemInfo > SystemsInfoType;
typedef ::std::vector< SinkStaticInfo > SinksStaticInfo;
typedef ::std::vector< SystemRegionInfo > SystemRegionsInfoType;
/* INFO:
 *  -> Param1: Id of the region
 *  -> Param2: System category
 *  -> Param3: System status category
 */
typedef ::boost::tuple< uint8, uint8, uint8 > SystemEnquiryInfo;
/* INFO:
 *  -> Param1: Id of the region
 *  -> Param2: Info of the sinks
 */
typedef ::std::vector< ::std::pair< uint32, SinkIdsInfo > > SupportedRegionsInfo;
} //namespace Core
} //namespace App


#endif /* REGION_HANDLING_CONSTANTS_H */
