/**************************************************************************************
* @file         : <RearViewCamera.cpp>
* @author       : <ECG> <INF4CV> Sathiya Jayanth Raman
* @addtogroup   : <AppHmi_System>
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include <vector>
#include "hall_std_if.h"
#include "RearViewCamera.h"
#include "Common/DataModel/ListRegistry.h"

#include "CanderaWidget/String/String.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_MASTER_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_MASTER
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_Master_"
#define ETG_I_FILE_PREFIX                 App::Core::RearViewCamera::
#include "trcGenProj/Header/RearViewCamera.cpp.trc.h"
#endif

using namespace ::rvc_cca_fi;
using namespace ::rvc_cca_fi_types;
using namespace ::App::Core;
using namespace ::asf::core;

namespace App {
namespace Core {

RearViewCamera* RearViewCamera::_RearViewClient = NULL;

RearViewCamera::RearViewCamera(): m_poRvcFiProxy(::rvc_cca_fi::Rvc_cca_fiProxy::createProxy("rvcFiPort", *this))
{
   ETG_I_REGISTER_FILE();
   ETG_TRACE_USR4(("RearViewCamera Constructor is called"));
   if (m_poRvcFiProxy)
   {
      StartupSync::getInstance().registerPropertyRegistrationIF(this, m_poRvcFiProxy->getPortName());
      ETG_TRACE_USR4(("RearViewCamera Constructor after creating proxy"));
   }
   else
   {
      ETG_TRACE_USR4(("RearViewCamera Constructor is failed"));
   }
}


RearViewCamera::~RearViewCamera()
{
   ETG_TRACE_USR4(("RearViewCamera destructor is called"));
}


void RearViewCamera::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
}


void RearViewCamera::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
}


void RearViewCamera::onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("RearViewCamera Service onAvailable"));
   m_poRvcFiProxy->sendReverseSignalStatusUpReg(*this);
}


void RearViewCamera::onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("RearViewCamera Service onUnavailable"));
   m_poRvcFiProxy->sendReverseSignalStatusRelUpRegAll();
}


void RearViewCamera::onReverseSignalStatusError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& /*proxy*/, const ::boost::shared_ptr< ReverseSignalStatusError >& /*error*/)
{
   ETG_TRACE_USR4(("RearViewCamera:: onReverseSignalStatusError"));
}


void RearViewCamera::onReverseSignalStatusStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& /*proxy*/, const ::boost::shared_ptr< ReverseSignalStatusStatus >& status)
{
   ETG_TRACE_USR4(("RearViewCamera:: onReverseSignalStatusStatus Reverse %u", status->getE8StatusReverseSignal()));
   bool isModified = false;
   switch (status->getE8StatusReverseSignal())
   {
      case T_e8_RVC_ReverseSignalStatus__On_NissanDebounced:
      {
         if (!sm_RVCStatus)
         {
            isModified   = true;
            sm_RVCStatus = true;
         }
         break;
      }
      case T_e8_RVC_ReverseSignalStatus__Off:
      {
         if (sm_RVCStatus)
         {
            isModified   = true;
            sm_RVCStatus = false;
         }
         break;
      }
      default:
         break;
   }
   if (isModified)
   {
      ActivateRVCSceneMsg* RVCSceneMsg = COURIER_MESSAGE_NEW(ActivateRVCSceneMsg)(sm_RVCStatus); //showpopup value is taken as sent by applications
      if (RVCSceneMsg != 0)
      {
         RVCSceneMsg->Post();
      }
      HmiInfoServiceServerComponent::poGetInstance()->sendRVCSignalUpdate(sm_RVCStatus);
   }
}


void RearViewCamera::onActivateDeactivateRVC(bool status)
{
   ETG_TRACE_USR4(("RearViewCamera:: onActivateDeactivateRVC"));
   if (status)
   {
      m_poRvcFiProxy->sendSetSystemStatusStart(*this, T_e8_RVC_SystemStatus__RVC_VISUALISATION_ON,
            static_cast<T_e8_RVC_StatusGuideLine>(0x02),
            T_e8_RVC_StatusWarningText__WarningTextOff);
   }
   else
   {
      m_poRvcFiProxy->sendSetSystemStatusStart(*this, T_e8_RVC_SystemStatus__VISUALISATION_OFF,
            static_cast<T_e8_RVC_StatusGuideLine>(0x02),
            T_e8_RVC_StatusWarningText__WarningTextOff);
   }
}


void RearViewCamera::onSetSystemStatusError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< SetSystemStatusError >& error)
{
}


void RearViewCamera::onSetSystemStatusResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< SetSystemStatusResult >& result)
{
}


void RearViewCamera::onToggleGpioPinOnOffError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< ToggleGpioPinOnOffError >& error)
{
}


void RearViewCamera::onToggleGpioPinOnOffResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< ToggleGpioPinOnOffResult >& result)
{
}


void RearViewCamera::onToggleGpioPinOnOffState()
{
   ETG_TRACE_USR4(("RearViewCamera::onToggleGpioPinOnOffState "));
   m_poRvcFiProxy->sendToggleGpioPinOnOffStart(*this);
}


void RearViewCamera::onSetRVCStatusError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< SetRVCStatusError >& error)
{
   ETG_TRACE_USR4(("RearViewCamera::onSetRVCStatusError "));
}


void RearViewCamera::onSetRVCStatusResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< SetRVCStatusResult >& result)
{
   ETG_TRACE_USR4(("RearViewCamera::onSetRVCStatusResult "));
}


void RearViewCamera::onRequestRVCbyNanoMessage(uint8 rvcstatus) //RVC status update at Startup
{
   ETG_TRACE_USR4(("RearViewCamera::onRequestRVCbyNanoMessage  %d ", rvcstatus));
   m_poRvcFiProxy->sendSetRVCStatusStart(*this, (rvcstatus == 1 ? 2: 1));
}


}//namespace
}//App
