/**
 * @file         : NanoMsgClientHandlerInterface.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : NanoMsgClientHandlerInterface is to handle the NanoMsgClientHandler
 *                 feature interfaces implementation
 * @copyright    : (C) 2016 Robert Bosch GmbH
 *                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef NANOMSG_CLIENT_HANDLER_INTERFACE_H
#define NANOMSG_CLIENT_HANDLER_INTERFACE_H


#include <asf/core/Types.h>

/**
 *  Classes Forward Declaration
 */

namespace App {
namespace Core {


class IRegionHandling;
class IHmiStateHandler;
class INanoMSGMic2StatusUpdCB;
class INanoMSGMic3StatusUpdCB;
}


}

/**
 *  Classes Declaration
 */

namespace App {
namespace Core {


class INanoMsgClientHandler
{
   public:
      /**
       *  Member Function Declaration
       */
      INanoMsgClientHandler() {}
      virtual ~INanoMsgClientHandler() {}
      virtual bool getMic2Status() const = 0;
      virtual bool getMic3Status() const = 0;
      virtual void setRegionHandling(IRegionHandling& imp) = 0;
      virtual void setHMIStateHandler(IHmiStateHandler& imp) = 0;
      virtual void setMic1AnnouncementRelay(const uint8 relayStatus) = 0;
      virtual void addMic2StatusListener(INanoMSGMic2StatusUpdCB& imp) = 0;
      virtual void removeMic2StatusListener(INanoMSGMic2StatusUpdCB& imp) = 0;
      virtual void addMic3StatusListener(INanoMSGMic3StatusUpdCB& imp) = 0;
      virtual void removeMic3StatusListener(INanoMSGMic3StatusUpdCB& imp) = 0;
};


class INanoMSGMic2StatusUpdCB
{
   public:
      /**
       *  Member Function Declaration
       */
      INanoMSGMic2StatusUpdCB() {}
      virtual ~INanoMSGMic2StatusUpdCB() {}
      virtual void onUpdateMic2Status(const bool status) = 0;
};


class INanoMSGMic3StatusUpdCB
{
   public:
      /**
       *  Member Function Declaration
       */
      INanoMSGMic3StatusUpdCB() {}
      virtual ~INanoMSGMic3StatusUpdCB() {}
      virtual void onUpdateMic3Status(const bool status) = 0;
};


} //namespace Core
} //namespace App

#endif /* NANOMSG_CLIENT_HANDLER_INTERFACE_H */
