/**************************************************************************************
* @file         : NanoMsgClientHandler.h
* @author       : RBEI/ECG5-INF4CV
* @addtogroup   : AppHmi_Master
* @brief        :
* @copyright    : (C) 2016 Robert Bosch GmbH
*                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#ifndef NanoMsgClientHandler_h
#define NanoMsgClientHandler_h

#include "AppBase/ServiceAvailableIF.h"
#include "bosch/cm/di/NanoMsgGenericInterfaceProxy.h"
#include "bosch/cm/di/NanoMsgGenericInterface.h"
#include "AppHmi_MasterStateMachine.h"
#include "AppHmi_MasterMessages.h"
#include <App/Core/NanoMsgClientHandler/NanoMsgClientHandlerInterface.h>
#include <App/Core/RegionHandling/RegionHandlingInterface.h>
#include <Core/HmiState/HmiStateHandlerInterface.h>


namespace App {
namespace Core {
class NanoMsgClientHandler : public INanoMsgClientHandler
   , public StartupSync::PropertyRegistrationIF
   , public ::asf::core::ServiceAvailableIF
   , public ::bosch::cm::di::NanoMsgGenericInterface::Sig_EventDigitalInputCallbackIF
   , public ::bosch::cm::di::NanoMsgGenericInterface::Sig_RspGetDigitalInputCallbackIF
   , public ::bosch::cm::di::NanoMsgGenericInterface::ReqGetDigitalInputCallbackIF
   , public ::bosch::cm::di::NanoMsgGenericInterface::ReqSetAnnouncementOutCallbackIF
{
   public:
      NanoMsgClientHandler();
      virtual ~NanoMsgClientHandler();
      virtual void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      virtual void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      void setMic1AnnouncementRelay(const uint8 relayStatus);

      void registerProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      void deregisterProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      virtual void onSig_EventDigitalInputError(const ::boost::shared_ptr< ::bosch::cm::di::NanoMsgGenericInterface::NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ::bosch::cm::di::NanoMsgGenericInterface::Sig_EventDigitalInputError >& error);

      virtual void onSig_EventDigitalInputSignal(const ::boost::shared_ptr< ::bosch::cm::di::NanoMsgGenericInterface::NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ::bosch::cm::di::NanoMsgGenericInterface::Sig_EventDigitalInputSignal >& signal);

      virtual void onReqGetDigitalInputError(const ::boost::shared_ptr< ::bosch::cm::di::NanoMsgGenericInterface::NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ::bosch::cm::di::NanoMsgGenericInterface::ReqGetDigitalInputError >& error);

      virtual void onReqGetDigitalInputResponse(const ::boost::shared_ptr< ::bosch::cm::di::NanoMsgGenericInterface::NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ::bosch::cm::di::NanoMsgGenericInterface::ReqGetDigitalInputResponse >& response) ;

      virtual void onSig_RspGetDigitalInputError(const ::boost::shared_ptr< ::bosch::cm::di::NanoMsgGenericInterface::NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ::bosch::cm::di::NanoMsgGenericInterface::Sig_RspGetDigitalInputError >& error);

      virtual void onSig_RspGetDigitalInputSignal(const ::boost::shared_ptr< ::bosch::cm::di::NanoMsgGenericInterface::NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ::bosch::cm::di::NanoMsgGenericInterface::Sig_RspGetDigitalInputSignal >& signal);

      virtual void onReqSetAnnouncementOutError(const ::boost::shared_ptr< ::bosch::cm::di::NanoMsgGenericInterface::NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ::bosch::cm::di::NanoMsgGenericInterface::ReqSetAnnouncementOutError >& error);

      virtual void onReqSetAnnouncementOutResponse(const ::boost::shared_ptr< ::bosch::cm::di::NanoMsgGenericInterface::NanoMsgGenericInterfaceProxy >& proxy, const ::boost::shared_ptr< ::bosch::cm::di::NanoMsgGenericInterface::ReqSetAnnouncementOutResponse >& response);

      inline void setRegionHandling(::App::Core::IRegionHandling& imp)
      {
         _regionHandling = (&imp);
      }

      inline void setHMIStateHandler(::App::Core::IHmiStateHandler& imp)
      {
         _hmiStateHandler = (&imp);
      }

      inline void addMic2StatusListener(INanoMSGMic2StatusUpdCB& imp)
      {
         ::std::vector< INanoMSGMic2StatusUpdCB* >::const_iterator itr = ::std::find(_mic2State.begin(), _mic2State.end(), (&imp));
         if (itr == _mic2State.end())
         {
            _mic2State.push_back((&imp));
         }
      }

      inline void removeMic2StatusListener(INanoMSGMic2StatusUpdCB& imp)
      {
         ::std::vector< INanoMSGMic2StatusUpdCB* >::iterator itr = ::std::find(_mic2State.begin(), _mic2State.end(), (&imp));
         if (itr != _mic2State.end())
         {
            (void)_mic2State.erase(itr);
         }
      }

      inline void addMic3StatusListener(INanoMSGMic3StatusUpdCB& imp)
      {
         ::std::vector< INanoMSGMic3StatusUpdCB* >::const_iterator itr = ::std::find(_mic3State.begin(), _mic3State.end(), (&imp));
         if (itr == _mic3State.end())
         {
            _mic3State.push_back((&imp));
         }
      }

      inline void removeMic3StatusListener(INanoMSGMic3StatusUpdCB& imp)
      {
         ::std::vector< INanoMSGMic3StatusUpdCB* >::iterator itr = ::std::find(_mic3State.begin(), _mic3State.end(), (&imp));
         if (itr != _mic3State.end())
         {
            (void)_mic3State.erase(itr);
         }
      }

      inline bool getMic2Status() const
      {
         return m_bMIC2Status;
      }

      inline bool getMic3Status() const
      {
         return m_bMIC3Status;
      }

      inline void setMic2Status(bool status)
      {
         m_bMIC2Status = status;
      }

      inline void setMic3Status(bool status)
      {
         m_bMIC3Status = status;
      }

   private:

      bool m_bMIC3Status;
      bool m_bMIC2Status;
      void vUpdateMic2StatusByNanoMessage(uint32 digitalInput);
      void vUpdateMic3StatusByNanoMessage(uint32 digitalInput);
      void vActivateRVCByNanoMessage(uint32 digitalInput);
      void setSpmStateOnMixsourceReq();

      ::boost::shared_ptr< ::bosch::cm::di::NanoMsgGenericInterface::NanoMsgGenericInterfaceProxy> m_poNanoMsgProxy;
      void vUpdateDigitalInputByNanoMsg(uint32 digitalInput);
      ::std::vector< INanoMSGMic2StatusUpdCB* > _mic2State;
      ::std::vector< INanoMSGMic3StatusUpdCB* > _mic3State;
      ::App::Core::IRegionHandling* _regionHandling;
      ::App::Core::IHmiStateHandler* _hmiStateHandler;
};


}
}


#endif
