/**
 * @file         : MediaClientHandlerInterface.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : MediaClientHandlerTypes is to handle the interface implementation of
 *                 feature MediaClientHandler
 * @copyright    : (C) 2016 Robert Bosch GmbH
 *                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef MEDIA_CLIENT_HANDLER_INTERFACE_H
#define MEDIA_CLIENT_HANDLER_INTERFACE_H


#include <vector>
#include <asf/core/Types.h>


/**
 *  Classes Forward Declaration
 */

namespace App {
namespace Core {


class DeviceConnectionInfo;
class IDeviceConnectionsCB;
}// namespace Core
}// namespace App


/**
 *  Classes Declaration
 */

namespace App {
namespace Core {


class IMediaClientHandler
{
   public:
      /**
       *  Member Function Declaration
       */
      IMediaClientHandler() {}
      virtual ~IMediaClientHandler() {}
      virtual bool fetchDeviceConnectionsInfo(::std::vector< DeviceConnectionInfo >& info) = 0;
      virtual void registerDeviceConnectionsUpdate(IDeviceConnectionsCB& imp) = 0;
      virtual void deregisterDeviceConnectionsUpdate(IDeviceConnectionsCB& imp) = 0;
};


class IDeviceConnectionsCB
{
   public:
      /**
       *  Member Function Declaration
       */
      IDeviceConnectionsCB() {}
      virtual ~IDeviceConnectionsCB() {}
      virtual void onDeviceConnections(const ::std::vector< DeviceConnectionInfo >& info) = 0;
};


}// namespace Core
}// namespace App


#endif /* MEDIA_CLIENT_HANDLER_INTERFACE_H */
