/**************************************************************************************
 * @file         : KeyRouterFactory.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : KeyRouterFactory is to provide factory impl for KeyRouter
 *                 (Factory & SingleTon Design Pattern)
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 **************************************************************************************/


#ifndef KEYROUTER_FACTORY_H
#define KEYROUTER_FACTORY_H


#include <vector>
#include <asf/core/Types.h>


namespace keyRouter {

class IKeyRouterInterface;
class IKeyRouterStubInterface;
class IKeyRouterUserInterface;
} //namespace keyRouter


namespace hmi {
namespace apphmi_master {

class IHmiAppCtrlAppInfoInterface;
} //namespace apphmi_master
} //namespace hmi


namespace keyRouterFactory {


class KeyRouterFactory
{
   public:
      /**
       *  Member Function Declaration
       */
      virtual ~KeyRouterFactory();
      static void createInstance();
      static KeyRouterFactory* deleteInstance();
      static KeyRouterFactory* getInstance();
      std::vector< ::keyRouter::IKeyRouterInterface* > getAllKeyRoutersInfo() const;
      ::keyRouter::IKeyRouterInterface* getKeyRouterOfId(const uint32 id) const;
      ::keyRouter::IKeyRouterInterface* getKeyRouterOfDisplayId(const uint32 id) const;
      void setKeyRouterStubImpl(::keyRouter::IKeyRouterStubInterface* imp);
      void setHmiAppCtrlAppInfoImpl(::hmi::apphmi_master::IHmiAppCtrlAppInfoInterface* imp);
      void setKeyRouterUserInterfaceImpl(::keyRouter::IKeyRouterUserInterface* imp);
      void createKeyRouters(const ::std::vector< uint32 >&);
      void createKeyRouters(const uint32 routersCount);
      //void deleteKeyRouter(const uint32 routerId);

   private:
      /**
       *  Member Function Declaration
       */
      KeyRouterFactory();
      KeyRouterFactory(const KeyRouterFactory& obj);
      KeyRouterFactory& operator= (const KeyRouterFactory& obj);
      void clearKeyRouters();
      /**
       *  Member Variables Declaration
       */
      static KeyRouterFactory* _keyRouterFactory;
      ::std::map< uint32, ::keyRouter::IKeyRouterInterface* > _keyRouters;
};


} //namespace keyRouterFactory


#endif /* KEYROUTER_FACTORY_H */
