/**************************************************************************************
 * @file         : IKeyRouterUserInterface.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : IKeyRouterUserInterface is to provide interface impl
 *                 for KeyRouter and user interface handler.
 *                 (Dependency Breaker Strategy)
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 **************************************************************************************/


#ifndef IKEYROUTER_USER_INTERFACE_H
#define IKEYROUTER_USER_INTERFACE_H


#include "KeyRouterTypes.h"


namespace keyRouter {


class IKeyRouterUserInterface
{
   public:
      IKeyRouterUserInterface() { }
      virtual ~IKeyRouterUserInterface() { }
      virtual int getHardKeyRegisteredApp(const ::keyRouterTypes::KeyInfo< uint32 >& hardKeyInfo) = 0;
      virtual int getEncoderRegisteredApp(const ::keyRouterTypes::KeyInfo< int32 >& encoderInfo) = 0;
};


} //namespace keyRouter


#endif /* IKEYROUTER_USER_INTERFACE_H */
