/**
 * @file         : HmiStateHandlerHelper.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : HmiStateHandlerHelper is to handle the HmiStateHandler feature
 *                 helper implementation
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef HMI_STATE_HANDLER_HELPER_H
#define HMI_STATE_HANDLER_HELPER_H


#include <string>
#include <asf/core/Types.h>


/**
 *  Member Functions (like "C")
 */

namespace App {
namespace Core {


uint8 convertSystemCategoryFromLCM(const uint8 category);
uint8 convert3BitSystemVoltageErrorStatusFromLCM(const uint8 status);
uint8 convert3BitSystemThermalErrorStatusFromLCM(const uint8 status);
uint8 convert3BitSystemPowerModeStatusFromLCM(const uint8 status);
uint8 convert2BitSystemConnectionStatusFromLCM(const uint8 status);
uint8 convertSystemCategoryFromString(const ::std::string& category);
uint8 getBitValue(const uint16 errorInfo, const uint8 index, const uint8 bits);
uint8 getSystemStatusForSPMState(const uint8 state, const bool pnmGrp10Status);
uint8 getSPMStateForSystemStatus(const uint8 systemState);
bool isSPMHMIStateON(const uint8 state);
bool isSPMHMIStateShowHMI(const uint8 state);
bool isSPMHMIStateAnimation(const uint8 state);
bool isSPMHMIStateInfotainmentOFF(const uint8 state);
bool isLastHmiStateValidForMic1Restoration(const uint8 lastHmiState, const uint8 pnmGrpStatus);
bool isLastHmiStateValidForMixedSourceRestoration(const uint8 lastHmiState);
}// namespace Core
}// namespace App


#endif /* HMI_STATE_HANDLER_HELPER_H */
