/**
 * @file         : HmiStateHandler.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : HmiStateHandler is to handle HALL implementation for
 *                 SPM_CORE_FI service
 * @copyright    : (c) 2017-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef HMI_STATE_HANDLER_H
#define HMI_STATE_HANDLER_H


#include "SPM_CORE_FIProxy.h"
#include "HmiStateHandlerInterface.h"
#include "lcmdbusclient_main_fiProxy.h"


/**
 *  Classes Declaration
 */

namespace App {
namespace Core {


class HmiStateHandler : public IHmiStateHandler
   , public ::asf::core::ServiceAvailableIF
   , public SPM_CORE_FI::HmiStateCallbackIF
   , public SPM_CORE_FI::OnOffTriggerCallbackIF
   , public SPM_CORE_FI::RestartSystemCallbackIF
   , public ::lcmdbusclient_main_fi::SubsystemerrorStatusCallbackIF
{
   public:
      /**
       *  Member Functions Declaration
       */
      HmiStateHandler();
      virtual ~HmiStateHandler();
      bool isPowerStateON() const;
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void onHmiStateError(const ::boost::shared_ptr< SPM_CORE_FI::SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SPM_CORE_FI::HmiStateError >& error);
      void onHmiStateStatus(const ::boost::shared_ptr< SPM_CORE_FI::SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SPM_CORE_FI::HmiStateStatus >& status);
      void onOnOffTriggerError(const ::boost::shared_ptr< SPM_CORE_FI::SPM_CORE_FIProxy >& /*proxy*/, const ::boost::shared_ptr< SPM_CORE_FI::OnOffTriggerError >& /*error*/) {}
      void onOnOffTriggerResult(const ::boost::shared_ptr< SPM_CORE_FI::SPM_CORE_FIProxy >& /*proxy*/, const ::boost::shared_ptr< SPM_CORE_FI::OnOffTriggerResult >& /*result*/) {}
      void onRestartSystemError(const ::boost::shared_ptr<SPM_CORE_FI::SPM_CORE_FIProxy >& /* proxy */, const ::boost::shared_ptr< SPM_CORE_FI::RestartSystemError >& /* error */) {}
      void onRestartSystemResult(const ::boost::shared_ptr<SPM_CORE_FI::SPM_CORE_FIProxy >& /* proxy */, const ::boost::shared_ptr< SPM_CORE_FI::RestartSystemResult >& /* result */) {};
      void onSubsystemerrorStatusError(const ::boost::shared_ptr< ::lcmdbusclient_main_fi::Lcmdbusclient_main_fiProxy >& proxy, const ::boost::shared_ptr< ::lcmdbusclient_main_fi::SubsystemerrorStatusError >& error);
      void onSubsystemerrorStatusStatus(const ::boost::shared_ptr< ::lcmdbusclient_main_fi::Lcmdbusclient_main_fiProxy >& proxy, const ::boost::shared_ptr< ::lcmdbusclient_main_fi::SubsystemerrorStatusStatus >& status);
      void sendRestartRequest();
      void sendHKeyPressedRequest();
      void sendFirstPicDrawnUpdate();
      void sendUserOnRequest(const bool status);
      void sendSubsystemerrorStatusGetRequest();
      void sendDiagStatus(const bool diagstatus);
      void sendStandByRequest(const bool status);
      void updateHMIStateChangeToSM(const uint8 hmiState);
      void onHmiStateStatus(const uint8 hmiState);

      inline bool getPNMGrp10Status() const
      {
         return _pnmGrp10Status;
      }

      inline bool getHourLogicExpireStatus() const
      {
         return _hourLogicExpireStatus;
      }

      inline uint8 getHmiState() const
      {
         return _currentHMIState;
      }

      inline uint8 getLastHmiState() const
      {
         return _lastHMIState;
      }
      void addHmiStateListener(IHmiStateListenerCB* imp)
      {
         addListener<IHmiStateListenerCB>(_hmiStateListeners, imp);
      }
      void addSubSytemsErrorStatusListener(ISubSytemsErrorStatusCB* imp)
      {
         addListener<ISubSytemsErrorStatusCB>(_subSytemsErrorStatusListeners, imp);
      }

      void addPNMGrp10StatusListener(IPNMGrp10StatusCB* imp)
      {
         addListener<IPNMGrp10StatusCB>(_pnmGrp10StatusListeners, imp);
      }

      void addHourLogicExpireStatusListener(IHourLogicExpireStatusCB* imp)
      {
         addListener<IHourLogicExpireStatusCB>(_hourLogicExpireStatusListeners, imp);
      }

      void removeHmiStateListener(IHmiStateListenerCB* imp)
      {
         removeListener<IHmiStateListenerCB>(_hmiStateListeners, imp);
      }

      void removePNMGrp10StatusListener(IPNMGrp10StatusCB* imp)
      {
         removeListener<IPNMGrp10StatusCB>(_pnmGrp10StatusListeners, imp);
      }

      void removeHourLogicExpireStatusListener(IHourLogicExpireStatusCB* imp)
      {
         removeListener<IHourLogicExpireStatusCB>(_hourLogicExpireStatusListeners, imp);
      }

      void removeSubSytemsErrorStatusListener(ISubSytemsErrorStatusCB* imp)
      {
         removeListener<ISubSytemsErrorStatusCB>(_subSytemsErrorStatusListeners, imp);
      }

   private:
      /**
       *  Member Functions Declaration
       */
      void setPNMGrp10Status(const bool status);
      void setHourLogicExpireStatus(const bool status);
      void sendHourLogicExpireStatusToSM(const uint8 status);
      void handleSubSystemsErrorStatus(const SubSystemsErrorStatusInfo& info);

      inline bool isMySPMProxy(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy) const
      {
         return (((NULL != _spmProxy.get()) && (_spmProxy == proxy)) ? true : false);
      }

      inline bool isMyLCMDBusClientProxy(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy) const
      {
         return (((NULL != _lcmDBusClientProxy.get()) && (_lcmDBusClientProxy == proxy)) ? true : false);
      }

      template< typename CBType >
      inline void addListener(::std::vector< CBType* >& info, CBType* imp)
      {
         if (::std::find(info.begin(), info.end(), imp) == info.end())
         {
            info.push_back(imp);
         }
      }

      template< typename CBType >
      inline void removeListener(::std::vector< CBType* >& info, CBType* imp)
      {
         typename ::std::vector< CBType* >::iterator itr = ::std::find(info.begin(), info.end(), imp);
         if (itr != info.end())
         {
            info.erase(itr);
         }
      }
      /**
       *  Member Variables Declaration
       */
      bool _pnmGrp10Status;
      bool _hourLogicExpireStatus;
      uint8 _lastHMIState;
      uint8 _currentHMIState;
      act_t _regIdHmiStateUpdate;
      act_t _regIdSubsystemerrorGetUpdate;
      act_t _regIdSubsystemerrorStatusUpdate;
      ::std::vector< IHmiStateListenerCB* > _hmiStateListeners;
      ::std::vector< IPNMGrp10StatusCB* > _pnmGrp10StatusListeners;
      ::std::vector< IHourLogicExpireStatusCB* > _hourLogicExpireStatusListeners;
      ::boost::shared_ptr< ::SPM_CORE_FI::SPM_CORE_FIProxy > _spmProxy;
      ::std::vector< ISubSytemsErrorStatusCB* >_subSytemsErrorStatusListeners;
      ::boost::shared_ptr< ::lcmdbusclient_main_fi::Lcmdbusclient_main_fiProxy > _lcmDBusClientProxy;
};


}// namespace Core
}// namespace App


#endif /* HMI_STATE_HANDLER_H */
