/**
 * @file         : HmiInfoServiceHandlingInterface.h
 * @author       : INF4CV - AppHmi_Master Team
 * @addtogroup   : AppHmi_Master
 * @brief        : HmiInfoServiceHandlingInterface is to handle the HmiInfoServiceHandling
 *                 feature interfaces implementation
 * @copyright    : (C) 2020 Robert Bosch GmbH
 *                 (C) 2020 Robert Bosch Engineering and Business Solutions Limited
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef HMIINFOSERVICE_HANDLING_INTERFACE_H
#define HMIINFOSERVICE_HANDLING_INTERFACE_H


#include <Core/RegionHandling/RegionHandlingConstants.h>
#include <Core/CabinConnectionHandler/CabinRestorationHandlerConstants.h>

#define HMI_INFOSERVICE_INTERFACE bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService


/**
 *  Classes Forward Declaration
 */
namespace bosch {
namespace cm {
namespace ai {
namespace hmi {
namespace hmiinfoservice {
namespace HmiInfoService {
class CabinVideoMixInfo;
}


}
}


}
}


}

class ISpiDeviceInfoListenerCB;
class ICabinVideoMixIndexListener;
class ICabinSourceConnectionStatusCB;
class ICabinVideoMixInfoImpl;

/**
 *  Typedefs Declaration
 */

typedef ::std::vector< HMI_INFOSERVICE_INTERFACE::CabinVideoMixInfo > CabinsVideoMixInfo;


/**
 *  Classes Declaration
 */

class IHmiInfoServiceServerComponent
{
   public:
      IHmiInfoServiceServerComponent() {}
      virtual ~IHmiInfoServiceServerComponent() {}
      virtual const CabinsVideoMixInfo& getCabinsVideoMixInfo() const = 0;
      virtual uint8 getCabinVideoMixIndex(const uint32 regionId) const = 0;
      virtual void addSpiDeviceInfoListener(ISpiDeviceInfoListenerCB& imp) = 0;
      virtual void removeSpiDeviceInfoListener(ISpiDeviceInfoListenerCB& imp) = 0;
      virtual void sendRegionsMapOutStatusInfo() = 0;
      virtual void sendRVCSignalUpdate(bool status) = 0;
      virtual void sendForegroundApplicationUpdate(int appID) = 0;
      virtual void sendCabinsSystemsInfoUpdate(const ::App::Core::SystemsInfoType& info) = 0;
      virtual void sendCabinsSourceRestorationInfo(const ::App::Core::RestoreRegionsInfo& info) = 0;
      virtual void addOrUpdateRegionsMapOutStatusInfo(const uint32 regionID, const uint32 glassID, const bool activeStatus) = 0;
      virtual void addVideoMixIndexListener(ICabinVideoMixIndexListener& imp) = 0;
      virtual void removeVideoMixIndexListener(ICabinVideoMixIndexListener& imp) = 0;
      virtual void addCabinSourceStatusListener(ICabinSourceConnectionStatusCB& imp) = 0;
      virtual void sendAVRestorationSignal(const uint32 cabinId, const int16 sourceId) = 0;
      virtual void removeCabinSourceStatusListener(ICabinSourceConnectionStatusCB& imp) = 0;
      virtual bool getCabinSourceStatus(const int16 srcID) = 0;
      virtual void setCabinVideoMixInfoImpl(ICabinVideoMixInfoImpl& imp) = 0;
      virtual void setCabinVideoMixInfo(const CabinsVideoMixInfo& cabinVideoMixInfoUpdate) = 0;
      virtual const HMI_INFOSERVICE_INTERFACE::CabinVideoMixInfo* getVideoMixInfoForRegion(const uint32 regionId) const = 0;
};


class ISpiDeviceInfoListenerCB
{
   public:
      ISpiDeviceInfoListenerCB() {}
      virtual ~ISpiDeviceInfoListenerCB() {}
      virtual void onDeviceInfoUpdate(const std::string deviceName, const uint8 deviceType, const uint8 deviceStatus) = 0;
};


class ICabinSourceConnectionStatusCB
{
   public:
      ICabinSourceConnectionStatusCB() {}
      virtual ~ICabinSourceConnectionStatusCB() {}
      virtual void onCabinSourceStatusUpdate() = 0;
};


class ICabinVideoMixInfoImpl
{
   public:
      ICabinVideoMixInfoImpl() {}
      virtual ~ICabinVideoMixInfoImpl() {}
      virtual void onSetCabinVideoMixInfo(const HMI_INFOSERVICE_INTERFACE::CabinVideoMixInfo cabinVideoMixInfoUpdate) = 0;
};


class ICabinVideoMixIndexListener
{
   public:
      ICabinVideoMixIndexListener() {}
      virtual ~ICabinVideoMixIndexListener() {}
      virtual void onVideoMixIndexUpdate(const uint32 regionId, const uint8 videoMixIndex, const uint8 reason) = 0;
};


#undef HMI_INFOSERVICE_INTERFACE

#endif
