/****************************************************************************
* Copyright (c) 2017-2020 Robert Bosch Car Multimedia GmbH
* duplication and disclosure to third parties is prohibited.
****************************************************************************/

#include "StubHandler_AppExt.h"
#include "BaseContract/generated/BaseMsgs.h"
#include "Project.h"
#include "AppBase/app_base_defines.h"
#include <algorithm>
#include "App/Core/KeyRouter/KeyRouterFactory.h"
#include "App/Core/KeyRouter/IKeyRouterInterface.h"


#include "hmi_trace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HMI_FW_APPCTRL_STUB
#include "trcGenProj/Header/StubHandler_AppExt.cpp.trc.h"
#endif

#include "App/Core/Utility/MasterUtility.h"
#define DP_INF4CV_VARIANTSELECTION_NAVI 1
#define DP_INF4CV_VARIANTSELECTION_NONNAVI 2

using namespace bosch::cm::ai::hmi::appctrl::HMIAppCtrl;
using namespace hmi::apphmi_master;
using namespace ::hmibase;
using namespace ::keyRouterFactory;
using namespace ::keyRouterTypes;
using namespace ::keyRouter;
//using namespace App::Core;
namespace hmi {
namespace apphmi_master {
StubHandler_AppExt::StubHandler_AppExt()
{
   ETG_I_REGISTER_FILE();
   // these applications are expected to be started

   int dp_VariantSelection = App::Core::MasterUtility::getVariantSelection_KDSValue();

   //   appName, appId, mandatory, surface, switchable, needsAudio, externalStart, service, isFallbackApp, hkCode
   _taskArray.addTask(new AppTask(hmibase::app::base::appHmi_Master, APPID_APPHMI_MASTER, true, 101, true, true, false, "", false, HARDKEYCODE_HK_KEY_CODE_INVALID));

   _taskArray.addTask(new AppTask("AppHmi_Media"     , APPID_APPHMI_MEDIA       , false, 111, true, true, false, "", false, 41));

   _taskArray.addTask(new AppTask("AppHmi_Tuner", APPID_APPHMI_TUNER  , false, 102, true, true, false, "", false, 2));
   _taskArray.addTask(new AppTask("AppHmi_Phone"     , APPID_APPHMI_PHONE       , false, 107, true, true, false, "", false, HARDKEYCODE_HK_KEY_CODE_INVALID));
   _taskArray.addTask(new AppTask("AppHmi_System"     , APPID_APPHMI_SYSTEM       , false, 118, true, true, false, "", false, HARDKEYCODE_HK_KEY_CODE_INVALID));
   _taskArray.addTask(new AppTask("AppHmi_Testmode"     , APPID_APPHMI_TESTMODE       , false, 123, true, true, false, "", false, HARDKEYCODE_HK_KEY_CODE_INVALID));

   _taskArray.addTask(new AppTask("AppHmi_SPI"     , APPID_APPHMI_SPI       , false, SURFACEID_MAIN_SURFACE_SPI, true, true, false, "", false, HARDKEYCODE_HK_KEY_CODE_INVALID));
   _taskArray.addTask(new AppTask("AppHmi_Sxm"     , APPID_APPHMI_SXM       , false, 108, true, true, false, "", false, HARDKEYCODE_HK_KEY_CODE_INVALID));

   if (dp_VariantSelection == DP_INF4CV_VARIANTSELECTION_NAVI)
   {
      _taskArray.addTask(new AppTask("AppHmi_Navigation"     , APPID_APPHMI_NAVIGATION       , false, 103, true, true, false, "", false, HARDKEYCODE_HK_KEY_CODE_INVALID));
      _taskArray.addTask(new AppTask("AppHmi_Sds"     , APPID_APPHMI_SDS       , false, SURFACEID_MAIN_SURFACE_SDS, true, true, false, "", false, HARDKEYCODE_HK_KEY_CODE_INVALID));
   }

#if defined VARIANT_S_FTR_ENABLE_CABIN_A_SUPPORT | defined VARIANT_S_FTR_ENABLE_CABIN_B_SUPPORT
   _taskArray.addTask(new AppTask("AppHmi_Camera"     , APPID_APPHMI_CAMERA       , false, SURFACEID_MAIN_SURFACE_CAMERA, true, true, false, "", false, HARDKEYCODE_HK_KEY_CODE_INVALID));
#endif
   //If the application is not expected to start or HMI master initialisation is not dependent on these applications, send the flag as false
}


void StubHandler_AppExt::onKeyForwardingRequest(const boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::KeyForwardingRequest >& request)
{
   IKeyRouterInterface* imp = KeyRouterFactory::getInstance()->getKeyRouterOfDisplayId(request->getKeyRequest().getDisplayId());
   if (NULL == imp)
   {
      ETG_TRACE_ERR(("onKeyForwardingRequest: Received key is not matched with any of KeyRouter: IKeyRouterInterface*: "));
      return;
   }
   KeyInfo< uint32 > keyInfo;
   keyInfo.setActId(request->getAct());
   keyInfo.setDisplayId(request->getKeyRequest().getDisplayId());
   keyInfo.setCode(request->getKeyRequest().getKeyCode());
   keyInfo.setState(request->getKeyRequest().getKeyState());
   keyInfo.setUserData(request->getKeyRequest().getUserData());
   keyInfo.setPidSender(request->getKeyRequest().getPidSender());
   keyInfo.setPidReceiver(request->getKeyRequest().getPidReceiver());
   imp->onHardKeyForwardingReq(keyInfo);
}


void StubHandler_AppExt::sendHardKeyInfoToBaseApp(const KeyInfo< uint32 >& hardKeyInfo)
{
   keyInfo info(hardKeyInfo.getCode(), hardKeyInfo.getState(), hardKeyInfo.getPidSender(), hardKeyInfo.getPidReceiver(), hardKeyInfo.getDisplayId(), hardKeyInfo.getUserData());
   boost::shared_ptr< KeyForwardingRequest > data = boost::shared_ptr< KeyForwardingRequest >(new KeyForwardingRequest(info));
   data->setAct(hardKeyInfo.getActId());
   StubHandler::onKeyForwardingRequest(data);
}


void StubHandler_AppExt::sendHardKeyInfoForwardingSig(const KeyInfo< uint32 >& hardKeyInfo/*const ::bosch::cm::ai::hmi::appctrl::HMIAppCtrl::keyInfo keyInfo*/)
{
   keyInfo info(hardKeyInfo.getCode(), hardKeyInfo.getState(), hardKeyInfo.getPidSender(), hardKeyInfo.getPidReceiver(), hardKeyInfo.getDisplayId(), hardKeyInfo.getUserData());
   sendKeyInfoForwardingSignal(info);
}


void StubHandler_AppExt::onEncoderForwardingRequest(const boost::shared_ptr< EncoderForwardingRequest >& request)
{
   IKeyRouterInterface* imp = KeyRouterFactory::getInstance()->getKeyRouterOfDisplayId(0); //TODO: Re-Visit -sve2cob
   if (NULL == imp)
   {
      ETG_TRACE_ERR(("onEncoderForwardingRequest: Received key is not matched with any of KeyRouter: IKeyRouterInterface*: "));
      return;
   }
   KeyInfo< int32 > keyInfo;
   keyInfo.setActId(request->getAct());
   keyInfo.setDisplayId(1);
   keyInfo.setCode(request->getEncoderRequest().getEncCode());
   keyInfo.setValue(request->getEncoderRequest().getEncValue());
   keyInfo.setUserData(request->getEncoderRequest().getUserData());
   keyInfo.setPidSender(request->getEncoderRequest().getPidSender());
   keyInfo.setPidReceiver(request->getEncoderRequest().getPidReceiver());
   imp->onEncoderForwardingReq(keyInfo);
}


void StubHandler_AppExt::sendEncoderInfoToBaseApp(const KeyInfo< int32 >& encCodeInfo)
{
   encoderInfo info(encCodeInfo.getCode(), encCodeInfo.getValue(), encCodeInfo.getPidSender(), encCodeInfo.getPidReceiver(), 0, encCodeInfo.getUserData());
   boost::shared_ptr< EncoderForwardingRequest > data = boost::shared_ptr< EncoderForwardingRequest >(new EncoderForwardingRequest(info));
   data->setAct(encCodeInfo.getActId());
   StubHandler::onEncoderForwardingRequest(data);
}


void StubHandler_AppExt::sendEncoderInfoForwardingSig(const KeyInfo< int32 >& encCodeInfo)
{
   encoderInfo info(encCodeInfo.getCode(), encCodeInfo.getValue(), encCodeInfo.getPidSender(), encCodeInfo.getPidReceiver(), 0, encCodeInfo.getUserData());
   sendEncoderInfoForwardingSignal(info);
}


void StubHandler_AppExt::onSetApplicationMandatoryRequest(const boost::shared_ptr<bosch::cm::ai::hmi::appctrl::HMIAppCtrl::SetApplicationMandatoryRequest>& data)
{
   ETG_TRACE_USR4(("StubHandler_AppExt::onSetApplicationMandatoryRequest"));
   _taskArray.setMandatory(data->getName(), data->getValue());
}


int StubHandler_AppExt::getPidOfApp(const int appId) const
{
   return _taskArray.getPid(appId);
}


::std::string StubHandler_AppExt::getApplicationNameForPid(const int pid) const
{
   ::std::string name = "";
   for (AppTaskArray::AppTasks::const_iterator itr = _taskArray.getAppTasks().begin(); (itr != _taskArray.getAppTasks().end()); ++itr)
   {
      if ((*itr)->getPid() == pid)
      {
         name = (*itr)->getAppIdentName();
         break;
      }
   }
   return name;
}


::std::string StubHandler_AppExt::getApplicationNameForAppId(const unsigned int appId) const
{
   ::std::string name = "";
   for (AppTaskArray::AppTasks::const_iterator itr = _taskArray.getAppTasks().begin(); (itr != _taskArray.getAppTasks().end()); ++itr)
   {
      if ((*itr)->getAppId() == appId)
      {
         name = (*itr)->getAppIdentName();
         break;
      }
   }
   return name;
}


unsigned int StubHandler_AppExt::getApplicationId(const ::std::string& appName) const
{
   unsigned int appId = APPID_APPHMI_UNKNOWN;
   for (AppTaskArray::AppTasks::const_iterator itr = _taskArray.getAppTasks().begin(); (itr != _taskArray.getAppTasks().end()); ++itr)
   {
      if (strcmp((*itr)->getAppIdentName().c_str(), appName.c_str()) == 0)
      {
         appId = (*itr)->getAppId();
         break;
      }
   }
   return appId;
}


bool StubHandler_AppExt::isAppPid(const int pid)
{
   bool isValid = false;
   if (_taskArray.isAppPid(pid))
   {
      isValid = true;
   }
   return isValid;
}


}
}
